// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_type_policy_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_create_html_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_create_script_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_create_url_callback.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"createHTML",
"createScript",
"createScriptURL",
};


}  // namespace 

TrustedTypePolicyOptions* TrustedTypePolicyOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  TrustedTypePolicyOptions* dictionary = MakeGarbageCollected<TrustedTypePolicyOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "TrustedTypePolicyOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 TrustedTypePolicyOptions::TrustedTypePolicyOptions() {
  
}

 TrustedTypePolicyOptions::TrustedTypePolicyOptions(v8::Isolate* isolate) {
  
}























void TrustedTypePolicyOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_create_html_);
visitor->Trace(member_create_script_);
visitor->Trace(member_create_script_url_);
bindings::InputDictionaryBase::Trace(visitor);
}

void TrustedTypePolicyOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "TrustedTypePolicyOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("createHTML");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8CreateHTMLCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_create_html_, member_create_html_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("createScript");
if (!bindings::GetDictionaryMemberFromV8Object<V8CreateScriptCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_create_script_, member_create_script_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("createScriptURL");
if (!bindings::GetDictionaryMemberFromV8Object<V8CreateURLCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_create_script_url_, member_create_script_url_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> TrustedTypePolicyOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
