// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRANSITION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRANSITION_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT TransitionEventInit : public EventInit {
  
  public:
static TransitionEventInit* Create() {
  return MakeGarbageCollected<TransitionEventInit>();
}
static TransitionEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TransitionEventInit>(isolate);
}
static TransitionEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TransitionEventInit();
explicit  TransitionEventInit(v8::Isolate* isolate);

bool hasElapsedTime() const {
  return true;
}
double elapsedTime() const {
  return member_elapsed_time_;
}
void setElapsedTime(double value) {
  member_elapsed_time_ = value;
}

bool hasPropertyName() const {
  return true;
}
const String& propertyName() const {
  return member_property_name_;
}
void setPropertyName(const String& value);
void setPropertyName(String&& value);

bool hasPseudoElement() const {
  return true;
}
const String& pseudoElement() const {
  return member_pseudo_element_;
}
void setPseudoElement(const String& value);
void setPseudoElement(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



double member_elapsed_time_{0.0};
String member_property_name_{""};
String member_pseudo_element_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRANSITION_EVENT_INIT_H_
