// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRACK_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRACK_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AudioTrack;
class ExceptionState;
class TextTrack;
class V8UnionAudioTrackOrTextTrackOrVideoTrack;
class VideoTrack;

class CORE_EXPORT TrackEventInit : public EventInit {
  
  public:
static TrackEventInit* Create() {
  return MakeGarbageCollected<TrackEventInit>();
}
static TrackEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TrackEventInit>(isolate);
}
static TrackEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TrackEventInit();
explicit  TrackEventInit(v8::Isolate* isolate);

bool hasTrack() const {
  return has_track_;
}
V8UnionAudioTrackOrTextTrackOrVideoTrack* track() const {
  DCHECK(hasTrack());
return member_track_.Get();
}
V8UnionAudioTrackOrTextTrackOrVideoTrack* getTrackOr(V8UnionAudioTrackOrTextTrackOrVideoTrack* fallback_value) const {
  if (!hasTrack()) {
  return fallback_value;
}
return member_track_.Get();
}
void setTrack(V8UnionAudioTrackOrTextTrackOrVideoTrack* value) {
  member_track_ = value;
has_track_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_track_ = false;

Member<V8UnionAudioTrackOrTextTrackOrVideoTrack> member_track_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRACK_EVENT_INIT_H_
