// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TIMELINE_TRIGGER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TIMELINE_TRIGGER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AnimationTimeline;
class ExceptionState;
class TimelineRangeOffset;
class V8UnionStringOrTimelineRangeOffset;

class CORE_EXPORT TimelineTriggerOptions : public bindings::InputDictionaryBase {
  
  public:
static TimelineTriggerOptions* Create() {
  return MakeGarbageCollected<TimelineTriggerOptions>();
}
static TimelineTriggerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TimelineTriggerOptions>(isolate);
}
static TimelineTriggerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TimelineTriggerOptions();
explicit  TimelineTriggerOptions(v8::Isolate* isolate);

bool hasExitRangeEnd() const {
  return true;
}
V8UnionStringOrTimelineRangeOffset* exitRangeEnd() const {
  return member_exit_range_end_.Get();
}
void setExitRangeEnd(V8UnionStringOrTimelineRangeOffset* value) {
  member_exit_range_end_ = value;
DCHECK(member_exit_range_end_);
}

bool hasExitRangeStart() const {
  return true;
}
V8UnionStringOrTimelineRangeOffset* exitRangeStart() const {
  return member_exit_range_start_.Get();
}
void setExitRangeStart(V8UnionStringOrTimelineRangeOffset* value) {
  member_exit_range_start_ = value;
DCHECK(member_exit_range_start_);
}

bool hasRangeEnd() const {
  return true;
}
V8UnionStringOrTimelineRangeOffset* rangeEnd() const {
  return member_range_end_.Get();
}
void setRangeEnd(V8UnionStringOrTimelineRangeOffset* value) {
  member_range_end_ = value;
DCHECK(member_range_end_);
}

bool hasRangeStart() const {
  return true;
}
V8UnionStringOrTimelineRangeOffset* rangeStart() const {
  return member_range_start_.Get();
}
void setRangeStart(V8UnionStringOrTimelineRangeOffset* value) {
  member_range_start_ = value;
DCHECK(member_range_start_);
}

bool hasTimeline() const {
  return has_timeline_;
}
AnimationTimeline* timeline() const {
  DCHECK(hasTimeline());
return member_timeline_.Get();
}
AnimationTimeline* getTimelineOr(AnimationTimeline* fallback_value) const {
  if (!hasTimeline()) {
  return fallback_value;
}
return member_timeline_.Get();
}
void setTimeline(AnimationTimeline* value) {
  member_timeline_ = value;
has_timeline_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_timeline_ = false;

Member<V8UnionStringOrTimelineRangeOffset> member_exit_range_end_;
Member<V8UnionStringOrTimelineRangeOffset> member_exit_range_start_;
Member<V8UnionStringOrTimelineRangeOffset> member_range_end_;
Member<V8UnionStringOrTimelineRangeOffset> member_range_start_;
Member<AnimationTimeline> member_timeline_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TIMELINE_TRIGGER_OPTIONS_H_
