// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_test_sequence_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8TestSequenceCallback::GetHumanReadableName() const {
  return "V8TestSequenceCallback";
}

v8::Maybe<Vector<String>> V8TestSequenceCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const Vector<int32_t>& arg1_numbers) {
  const char* const class_like_name = "TestSequenceCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<Vector<String>>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<Vector<String>>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<Vector<String>>();
}
return helper.Result<IDLSequence<IDLString>, Vector<String>>();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_numbers;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_numbers = ToV8Traits<IDLSequence<IDLLong>>::ToV8(script_state, arg1_numbers);
argv[0] = v8_arg1_numbers;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<Vector<String>>();
}
return helper.Result<IDLSequence<IDLString>, Vector<String>>();
}

v8::Maybe<Vector<String>> V8TestSequenceCallback::Construct(const Vector<int32_t>& arg1_numbers) {
  const char* const class_like_name = "TestSequenceCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<Vector<String>>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<Vector<String>>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<Vector<String>>();
}
return helper.Result<IDLSequence<IDLString>, Vector<String>>();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_numbers;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_numbers = ToV8Traits<IDLSequence<IDLLong>>::ToV8(script_state, arg1_numbers);
argv[0] = v8_arg1_numbers;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<Vector<String>>();
}
return helper.Result<IDLSequence<IDLString>, Vector<String>>();
}




}  // namespace blink
