// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHOW_CONTEXT_MENU_ITEM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHOW_CONTEXT_MENU_ITEM_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class Accelerator;
class ExceptionState;
class ShowContextMenuItem;

class CORE_EXPORT ShowContextMenuItem : public bindings::InputDictionaryBase {
  
  public:
static ShowContextMenuItem* Create() {
  return MakeGarbageCollected<ShowContextMenuItem>();
}
static ShowContextMenuItem* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ShowContextMenuItem>(isolate);
}
static ShowContextMenuItem* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ShowContextMenuItem();
explicit  ShowContextMenuItem(v8::Isolate* isolate);

bool hasAccelerator() const {
  return has_accelerator_;
}
Accelerator* accelerator() const {
  DCHECK(hasAccelerator());
return member_accelerator_.Get();
}
Accelerator* getAcceleratorOr(Accelerator* fallback_value) const {
  if (!hasAccelerator()) {
  return fallback_value;
}
return member_accelerator_.Get();
}
void setAccelerator(Accelerator* value) {
  member_accelerator_ = value;
has_accelerator_ = true;
DCHECK(member_accelerator_);
}

bool hasChecked() const {
  return true;
}
bool checked() const {
  return member_checked_;
}
void setChecked(bool value) {
  member_checked_ = value;
}

bool hasEnabled() const {
  return true;
}
bool enabled() const {
  return member_enabled_;
}
void setEnabled(bool value) {
  member_enabled_ = value;
}

bool hasFeatureName() const {
  return has_feature_name_;
}
const String& featureName() const {
  DCHECK(hasFeatureName());
return member_feature_name_;
}
String getFeatureNameOr(const String& fallback_value) const;
String getFeatureNameOr(String&& fallback_value) const;
void setFeatureName(const String& value);
void setFeatureName(String&& value);

bool hasId() const {
  return has_id_;
}
uint16_t id() const {
  DCHECK(hasId());
return member_id_;
}
uint16_t getIdOr(uint16_t fallback_value) const {
  if (!hasId()) {
  return fallback_value;
}
return member_id_;
}
void setId(uint16_t value) {
  member_id_ = value;
has_id_ = true;
}

bool hasIsDevToolsPerformanceMenuItem() const {
  return true;
}
bool isDevToolsPerformanceMenuItem() const {
  return member_is_dev_tools_performance_menu_item_;
}
void setIsDevToolsPerformanceMenuItem(bool value) {
  member_is_dev_tools_performance_menu_item_ = value;
}

bool hasIsExperimentalFeature() const {
  return true;
}
bool isExperimentalFeature() const {
  return member_is_experimental_feature_;
}
void setIsExperimentalFeature(bool value) {
  member_is_experimental_feature_ = value;
}

bool hasLabel() const {
  return has_label_;
}
const String& label() const {
  DCHECK(hasLabel());
return member_label_;
}
String getLabelOr(const String& fallback_value) const;
String getLabelOr(String&& fallback_value) const;
void setLabel(const String& value);
void setLabel(String&& value);

bool hasSubItems() const {
  return has_sub_items_;
}
const HeapVector<Member<ShowContextMenuItem>>& subItems() const {
  DCHECK(hasSubItems());
return member_sub_items_;
}
HeapVector<Member<ShowContextMenuItem>> getSubItemsOr(const HeapVector<Member<ShowContextMenuItem>>& fallback_value) const;
HeapVector<Member<ShowContextMenuItem>> getSubItemsOr(HeapVector<Member<ShowContextMenuItem>>&& fallback_value) const;
void setSubItems(const HeapVector<Member<ShowContextMenuItem>>& value);
void setSubItems(HeapVector<Member<ShowContextMenuItem>>&& value);

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_accelerator_ = false;
bool has_feature_name_ = false;
bool has_id_ = false;
bool has_label_ = false;
bool has_sub_items_ = false;

Member<Accelerator> member_accelerator_;
bool member_checked_{false};
bool member_enabled_{true};
String member_feature_name_;
uint16_t member_id_;
bool member_is_dev_tools_performance_menu_item_{false};
bool member_is_experimental_feature_{false};
String member_label_;
HeapVector<Member<ShowContextMenuItem>> member_sub_items_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHOW_CONTEXT_MENU_ITEM_H_
