// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_shadow_root_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/html/custom/custom_element_registry.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"clonable",
"customElementRegistry",
"delegatesFocus",
"mode",
"referenceTarget",
"serializable",
"slotAssignment",
};


}  // namespace 

ShadowRootInit* ShadowRootInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ShadowRootInit* dictionary = MakeGarbageCollected<ShadowRootInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ShadowRootInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ShadowRootInit::ShadowRootInit() {
  
}

 ShadowRootInit::ShadowRootInit(v8::Isolate* isolate) {
  
}





























String ShadowRootInit::getReferenceTargetOr(const String& fallback_value) const {
  if (!hasReferenceTarget()) {
  return fallback_value;
}
return member_reference_target_;
}

String ShadowRootInit::getReferenceTargetOr(String&& fallback_value) const {
  if (!hasReferenceTarget()) {
  return std::move(fallback_value);
}
return member_reference_target_;
}

void ShadowRootInit::setReferenceTarget(const String& value) {
  member_reference_target_ = value;
has_reference_target_ = true;
}

void ShadowRootInit::setReferenceTarget(String&& value) {
  member_reference_target_ = std::move(value);
has_reference_target_ = true;
}

















void ShadowRootInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_custom_element_registry_);
bindings::InputDictionaryBase::Trace(visitor);
}

void ShadowRootInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ShadowRootInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("clonable");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_clonable_, member_clonable_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::ScopedCustomElementRegistryEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("customElementRegistry");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<CustomElementRegistry>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_custom_element_registry_, member_custom_element_registry_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("delegatesFocus");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_delegates_focus_, member_delegates_focus_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mode");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8ShadowRootMode, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_mode_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::ShadowRootReferenceTargetEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("referenceTarget");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_reference_target_, member_reference_target_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("serializable");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_serializable_, member_serializable_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("slotAssignment");
if (!bindings::GetDictionaryMemberFromV8Object<V8SlotAssignmentMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_slot_assignment_, member_slot_assignment_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ShadowRootInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
