// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SET_HTML_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SET_HTML_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_presets.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Sanitizer;
class SanitizerConfig;
class V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets;

class CORE_EXPORT SetHTMLOptions : public bindings::InputDictionaryBase {
  
  public:
static SetHTMLOptions* Create() {
  return MakeGarbageCollected<SetHTMLOptions>();
}
static SetHTMLOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SetHTMLOptions>(isolate);
}
static SetHTMLOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SetHTMLOptions();
explicit  SetHTMLOptions(v8::Isolate* isolate);

bool hasSanitizer() const {
  return true;
}
V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets* sanitizer() const {
  return member_sanitizer_.Get();
}
void setSanitizer(V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets* value) {
  member_sanitizer_ = value;
DCHECK(member_sanitizer_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets> member_sanitizer_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SET_HTML_OPTIONS_H_
