// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_REGISTERED_TOOL_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_REGISTERED_TOOL_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT RegisteredTool : public bindings::DictionaryBase {
  
  public:
static RegisteredTool* Create() {
  return MakeGarbageCollected<RegisteredTool>();
}
static RegisteredTool* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RegisteredTool>(isolate);
}
static RegisteredTool* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RegisteredTool();
explicit  RegisteredTool(v8::Isolate* isolate);

bool hasDescription() const {
  return true;
}
const String& description() const {
  return member_description_;
}
void setDescription(const String& value);
void setDescription(String&& value);

bool hasInputSchema() const {
  return has_input_schema_;
}
const String& inputSchema() const {
  DCHECK(hasInputSchema());
return member_input_schema_;
}
String getInputSchemaOr(const String& fallback_value) const;
String getInputSchemaOr(String&& fallback_value) const;
void setInputSchema(const String& value);
void setInputSchema(String&& value);

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_input_schema_ = false;

String member_description_;
String member_input_schema_;
String member_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_REGISTERED_TOOL_H_
