// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_READABLE_STREAM_READ_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_READABLE_STREAM_READ_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ReadableStreamReadResult : public bindings::DictionaryBase {
  
  public:
static ReadableStreamReadResult* Create() {
  return MakeGarbageCollected<ReadableStreamReadResult>();
}
static ReadableStreamReadResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ReadableStreamReadResult>(isolate);
}
static ReadableStreamReadResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ReadableStreamReadResult();
explicit  ReadableStreamReadResult(v8::Isolate* isolate);

bool hasDone() const {
  return has_done_;
}
bool done() const {
  DCHECK(hasDone());
return member_done_;
}
bool getDoneOr(bool fallback_value) const {
  if (!hasDone()) {
  return fallback_value;
}
return member_done_;
}
void setDone(bool value) {
  member_done_ = value;
has_done_ = true;
}

bool hasValue() const {
  return !member_value_.IsEmpty();
}
const ScriptValue& value() const {
  DCHECK(hasValue());
return member_value_;
}
ScriptValue getValueOr(const ScriptValue& fallback_value) const {
  if (!hasValue()) {
  return fallback_value;
}
return member_value_;
}
void setValue(const ScriptValue& value) {
  member_value_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_done_ = false;

bool member_done_;
ScriptValue member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_READABLE_STREAM_READ_RESULT_H_
