// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_QUOTA_EXCEEDED_ERROR_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_QUOTA_EXCEEDED_ERROR_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT QuotaExceededErrorOptions : public bindings::InputDictionaryBase {
  
  public:
static QuotaExceededErrorOptions* Create() {
  return MakeGarbageCollected<QuotaExceededErrorOptions>();
}
static QuotaExceededErrorOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<QuotaExceededErrorOptions>(isolate);
}
static QuotaExceededErrorOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  QuotaExceededErrorOptions();
explicit  QuotaExceededErrorOptions(v8::Isolate* isolate);

bool hasQuota() const {
  return has_quota_;
}
double quota() const {
  DCHECK(hasQuota());
return member_quota_;
}
double getQuotaOr(double fallback_value) const {
  if (!hasQuota()) {
  return fallback_value;
}
return member_quota_;
}
void setQuota(double value) {
  member_quota_ = value;
has_quota_ = true;
}

bool hasRequested() const {
  return has_requested_;
}
double requested() const {
  DCHECK(hasRequested());
return member_requested_;
}
double getRequestedOr(double fallback_value) const {
  if (!hasRequested()) {
  return fallback_value;
}
return member_requested_;
}
void setRequested(double value) {
  member_requested_ = value;
has_requested_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_quota_ = false;
bool has_requested_ = false;

double member_quota_;
double member_requested_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_QUOTA_EXCEEDED_ERROR_OPTIONS_H_
