// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_preference_object.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/frozen_array.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/preferences/preference_object.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8PreferenceObject::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && execution_context->IsWindow() && RuntimeEnabledFeatures::WebPreferencesEnabled();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8PreferenceObject::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8PreferenceObject::InstallInterfaceTemplate,
    nullptr,
    "PreferenceObject",
    V8EventTarget::GetWrapperTypeInfo(),
    V8PreferenceObject::kThisTag,
    V8PreferenceObject::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& PreferenceObject::wrapper_type_info_ =
    V8PreferenceObject::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, PreferenceObject>::value,
    "PreferenceObject inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_preference_object {


void OverrideAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_override_Getter");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.override.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->override(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}



void ValueAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_value_Getter");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.value.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->value(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void ValidValuesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_validValues_Getter");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.validValues.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->validValues();
static_assert(bindings::IsReturnTypeCompatible<IDLArray<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLArray<IDLString>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}



void OnchangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_onchange_Getter");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.onchange.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onchange();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnchangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_onchange_Setter");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.onchange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnchange(event_handler);
}

void ClearOverrideOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_clearOverride");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.clearOverride");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
blink_receiver->clearOverride(script_state);

}

void RequestOverrideOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PreferenceObject_requestOverride");
BLINK_BINDINGS_TRACE_EVENT("PreferenceObject.requestOverride");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8PreferenceObject::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


PreferenceObject* blink_receiver = V8PreferenceObject::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "PreferenceObject";
const char* const property_name = "requestOverride";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->requestOverride(script_state, arg1_value);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_preference_object

using namespace v8_preference_object;

}  // namespace 

void V8PreferenceObject::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8PreferenceObject::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8PreferenceObject::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"override", OverrideAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"value", ValueAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"validValues", ValidValuesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onchange", OnchangeAttributeGetCallback, OnchangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "PreferenceObject", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clearOverride", ClearOverrideOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"requestOverride", RequestOverrideOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PreferenceObject", kOperationTable);
}



}




}  // namespace blink
