// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PAGE_REVEAL_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PAGE_REVEAL_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMViewTransition;
class ExceptionState;

class CORE_EXPORT PageRevealEventInit : public EventInit {
  
  public:
static PageRevealEventInit* Create() {
  return MakeGarbageCollected<PageRevealEventInit>();
}
static PageRevealEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PageRevealEventInit>(isolate);
}
static PageRevealEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PageRevealEventInit();
explicit  PageRevealEventInit(v8::Isolate* isolate);

bool hasViewTransition() const {
  return true;
}
DOMViewTransition* viewTransition() const {
  return member_view_transition_.Get();
}
void setViewTransition(DOMViewTransition* value) {
  member_view_transition_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<DOMViewTransition> member_view_transition_{nullptr};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PAGE_REVEAL_EVENT_INIT_H_
