// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_node_iterator.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_node.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_node_filter.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/dom/node.h"
#include "third_party/blink/renderer/core/dom/node_iterator.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8NodeIterator::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8NodeIterator::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8NodeIterator::InstallInterfaceTemplate,
    nullptr,
    "NodeIterator",
    nullptr,
    V8NodeIterator::kThisTag,
    V8NodeIterator::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& NodeIterator::wrapper_type_info_ =
    V8NodeIterator::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, NodeIterator>::value,
    "NodeIterator inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_node_iterator {


void RootAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_root_Getter");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.root.get");


{
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
ExecutionContext* node_execution_context = blink_receiver->root()->GetExecutionContext();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ScriptState* node_script_state = script_state;
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (node_execution_context && execution_context != node_execution_context) [[unlikely]] {
  node_script_state = ToScriptState(node_execution_context, script_state->World());
if (!node_script_state) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
}
// [NodeWrapInOwnContext]
auto&& return_value = blink_receiver->root();
static_assert(bindings::IsReturnTypeCompatible<Node, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_value = ToV8Traits<Node>::ToV8(node_script_state, return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}



void ReferenceNodeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_referenceNode_Getter");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.referenceNode.get");


{
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
ExecutionContext* node_execution_context = blink_receiver->root()->GetExecutionContext();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ScriptState* node_script_state = script_state;
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (node_execution_context && execution_context != node_execution_context) [[unlikely]] {
  node_script_state = ToScriptState(node_execution_context, script_state->World());
if (!node_script_state) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
}
// [NodeWrapInOwnContext]
auto&& return_value = blink_receiver->referenceNode();
static_assert(bindings::IsReturnTypeCompatible<Node, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_value = ToV8Traits<Node>::ToV8(node_script_state, return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}



void PointerBeforeReferenceNodeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_pointerBeforeReferenceNode_Getter");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.pointerBeforeReferenceNode.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->pointerBeforeReferenceNode();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void WhatToShowAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_whatToShow_Getter");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.whatToShow.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->whatToShow();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}



void FilterAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_filter_Getter");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.filter.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->filter();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<V8NodeFilter>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<V8NodeFilter>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}


void DetachOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_detach");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.detach");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNodeIteratorDetach);



v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->detach();

}

void NextNodeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_nextNode");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.nextNode");





{
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
ExecutionContext* node_execution_context = blink_receiver->root()->GetExecutionContext();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ScriptState* node_script_state = script_state;
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (node_execution_context && execution_context != node_execution_context) [[unlikely]] {
  node_script_state = ToScriptState(node_execution_context, script_state->World());
if (!node_script_state) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
}
// [NodeWrapInOwnContext]
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->nextNode(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Node>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Value> v8_value = ToV8Traits<IDLNullable<Node>>::ToV8(node_script_state, return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}

void PreviousNodeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_NodeIterator_previousNode");
BLINK_BINDINGS_TRACE_EVENT("NodeIterator.previousNode");





{
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
NodeIterator* blink_receiver = V8NodeIterator::ToWrappableUnsafe(isolate, v8_receiver);
ExecutionContext* node_execution_context = blink_receiver->root()->GetExecutionContext();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ScriptState* node_script_state = script_state;
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (node_execution_context && execution_context != node_execution_context) [[unlikely]] {
  node_script_state = ToScriptState(node_execution_context, script_state->World());
if (!node_script_state) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
}
// [NodeWrapInOwnContext]
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->previousNode(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Node>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Value> v8_value = ToV8Traits<IDLNullable<Node>>::ToV8(node_script_state, return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}


}  // namespace v8_node_iterator

using namespace v8_node_iterator;

}  // namespace 

void V8NodeIterator::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8NodeIterator::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8NodeIterator::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"root", RootAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"referenceNode", ReferenceNodeAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"pointerBeforeReferenceNode", PointerBeforeReferenceNodeAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"whatToShow", WhatToShowAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"filter", FilterAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "NodeIterator", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"detach", DetachOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"nextNode", NextNodeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"previousNode", PreviousNodeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "NodeIterator", kOperationTable);
}



}




}  // namespace blink
