// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NODE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NODE_H_

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/v8_interface_bridge.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {

class ExecutionContext;
class Node;
struct WrapperTypeInfo;

class CORE_EXPORT V8Node final : public bindings::V8InterfaceBridge<V8Node, Node> {
  
  public:
// Constants
class Constant final {
  STATIC_ONLY(Constant);

  public:
static constexpr uint16_t kElementNode = 1;
static constexpr uint16_t kAttributeNode = 2;
static constexpr uint16_t kTextNode = 3;
static constexpr uint16_t kCdataSectionNode = 4;
static constexpr uint16_t kEntityReferenceNode = 5;
static constexpr uint16_t kEntityNode = 6;
static constexpr uint16_t kProcessingInstructionNode = 7;
static constexpr uint16_t kCommentNode = 8;
static constexpr uint16_t kDocumentNode = 9;
static constexpr uint16_t kDocumentTypeNode = 10;
static constexpr uint16_t kDocumentFragmentNode = 11;
static constexpr uint16_t kNotationNode = 12;
static constexpr uint16_t kDocumentPositionDisconnected = 0x01;
static constexpr uint16_t kDocumentPositionPreceding = 0x02;
static constexpr uint16_t kDocumentPositionFollowing = 0x04;
static constexpr uint16_t kDocumentPositionContains = 0x08;
static constexpr uint16_t kDocumentPositionContainedBy = 0x10;
static constexpr uint16_t kDocumentPositionImplementationSpecific = 0x20;

  
  
  
};

static bool IsExposed(ExecutionContext* execution_context);

static constexpr const WrapperTypeInfo* GetWrapperTypeInfo() {
  return &wrapper_type_info_;
}
  static_assert(574 <
                 blink::kLastGeneratedScriptWrappableTag,
                 "There are more ScriptWrappable types than available type tags."
                 "You have to increase the kLastScirptWrappableTag in wrapper_type_info.h");
  static constexpr v8::CppHeapPointerTag kThisTag =
      static_cast<v8::CppHeapPointerTag>(574);
  static constexpr v8::CppHeapPointerTag kMaxSubclassTag =
      static_cast<v8::CppHeapPointerTag>(739);
  static constexpr v8::CppHeapPointerTagRange kTagRange =
      v8::CppHeapPointerTagRange(kThisTag, kMaxSubclassTag);


static void InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template);
static void InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template);


  
  private:
static const WrapperTypeInfo wrapper_type_info_;


  friend class Node;
};

namespace bindings {

namespace v8_context_snapshot {

CORE_EXPORT
base::span<const intptr_t> GetRefTableOfV8Node();

CORE_EXPORT
void InstallPropsOfV8Node(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template);

CORE_EXPORT
void InstallPropsOfV8Node(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template);


}  // namespace v8_context_snapshot

}  // namespace bindings


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NODE_H_
