// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATOR_UA_BRAND_VERSION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATOR_UA_BRAND_VERSION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT NavigatorUABrandVersion : public bindings::DictionaryBase {
  
  public:
static NavigatorUABrandVersion* Create() {
  return MakeGarbageCollected<NavigatorUABrandVersion>();
}
static NavigatorUABrandVersion* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NavigatorUABrandVersion>(isolate);
}
static NavigatorUABrandVersion* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NavigatorUABrandVersion();
explicit  NavigatorUABrandVersion(v8::Isolate* isolate);

bool hasBrand() const {
  return has_brand_;
}
const String& brand() const {
  DCHECK(hasBrand());
return member_brand_;
}
String getBrandOr(const String& fallback_value) const;
String getBrandOr(String&& fallback_value) const;
void setBrand(const String& value);
void setBrand(String&& value);

bool hasVersion() const {
  return has_version_;
}
const String& version() const {
  DCHECK(hasVersion());
return member_version_;
}
String getVersionOr(const String& fallback_value) const;
String getVersionOr(String&& fallback_value) const;
void setVersion(const String& value);
void setVersion(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_brand_ = false;
bool has_version_ = false;

String member_brand_;
String member_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATOR_UA_BRAND_VERSION_H_
