// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_navigator_ua_brand_version.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"brand",
"version",
};


}  // namespace 

NavigatorUABrandVersion* NavigatorUABrandVersion::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  NavigatorUABrandVersion* dictionary = MakeGarbageCollected<NavigatorUABrandVersion>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "NavigatorUABrandVersion";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 NavigatorUABrandVersion::NavigatorUABrandVersion() {
  
}

 NavigatorUABrandVersion::NavigatorUABrandVersion(v8::Isolate* isolate) {
  
}



String NavigatorUABrandVersion::getBrandOr(const String& fallback_value) const {
  if (!hasBrand()) {
  return fallback_value;
}
return member_brand_;
}

String NavigatorUABrandVersion::getBrandOr(String&& fallback_value) const {
  if (!hasBrand()) {
  return std::move(fallback_value);
}
return member_brand_;
}

void NavigatorUABrandVersion::setBrand(const String& value) {
  member_brand_ = value;
has_brand_ = true;
}

void NavigatorUABrandVersion::setBrand(String&& value) {
  member_brand_ = std::move(value);
has_brand_ = true;
}




String NavigatorUABrandVersion::getVersionOr(const String& fallback_value) const {
  if (!hasVersion()) {
  return fallback_value;
}
return member_version_;
}

String NavigatorUABrandVersion::getVersionOr(String&& fallback_value) const {
  if (!hasVersion()) {
  return std::move(fallback_value);
}
return member_version_;
}

void NavigatorUABrandVersion::setVersion(const String& value) {
  member_version_ = value;
has_version_ = true;
}

void NavigatorUABrandVersion::setVersion(String&& value) {
  member_version_ = std::move(value);
has_version_ = true;
}



void NavigatorUABrandVersion::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void NavigatorUABrandVersion::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void NavigatorUABrandVersion::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBrand()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_brand_);
DCHECK(!values[0].IsEmpty());
}
if (hasVersion()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_version_);
DCHECK(!values[1].IsEmpty());
}
}

const void* NavigatorUABrandVersion::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> NavigatorUABrandVersion::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void NavigatorUABrandVersion::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "NavigatorUABrandVersion";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("brand");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_brand_, member_brand_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("version");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_version_, member_version_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> NavigatorUABrandVersion::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
