// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_mathml_element.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/mathml/mathml_element.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8MathMLElement::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8MathMLElement::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8MathMLElement::InstallInterfaceTemplate,
    V8MathMLElement::InstallContextDependentProperties,
    "MathMLElement",
    V8Element::GetWrapperTypeInfo(),
    V8MathMLElement::kThisTag,
    V8MathMLElement::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kNodeClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& MathMLElement::wrapper_type_info_ =
    V8MathMLElement::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, MathMLElement>::value,
    "MathMLElement inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

// Cross-component trampolines
V8MathMLElement::InstallInterfaceTemplateFuncType V8MathMLElement::install_interface_template_func_ = nullptr;
V8MathMLElement::InstallUnconditionalPropertiesFuncType V8MathMLElement::install_unconditional_props_func_ = nullptr;
V8MathMLElement::InstallContextIndependentPropertiesFuncType V8MathMLElement::install_context_independent_props_func_ = nullptr;
V8MathMLElement::InstallContextDependentPropertiesFuncType V8MathMLElement::install_context_dependent_props_func_ = nullptr;


}  // namespace blink
