// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTRINSIC_SIZES_RESULT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTRINSIC_SIZES_RESULT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT IntrinsicSizesResultOptions : public bindings::DictionaryBase {
  
  public:
static IntrinsicSizesResultOptions* Create() {
  return MakeGarbageCollected<IntrinsicSizesResultOptions>();
}
static IntrinsicSizesResultOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IntrinsicSizesResultOptions>(isolate);
}
static IntrinsicSizesResultOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IntrinsicSizesResultOptions();
explicit  IntrinsicSizesResultOptions(v8::Isolate* isolate);

bool hasMaxContentSize() const {
  return true;
}
double maxContentSize() const {
  return member_max_content_size_;
}
void setMaxContentSize(double value) {
  member_max_content_size_ = value;
}

bool hasMinContentSize() const {
  return true;
}
double minContentSize() const {
  return member_min_content_size_;
}
void setMinContentSize(double value) {
  member_min_content_size_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



double member_max_content_size_{0};
double member_min_content_size_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTRINSIC_SIZES_RESULT_OPTIONS_H_
