// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_html_media_element.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_element.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/html/media/html_media_element.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8HTMLMediaElement::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8HTMLMediaElement::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8HTMLMediaElement::InstallInterfaceTemplate,
    V8HTMLMediaElement::InstallContextDependentProperties,
    "HTMLMediaElement",
    V8HTMLElement::GetWrapperTypeInfo(),
    V8HTMLMediaElement::kThisTag,
    V8HTMLMediaElement::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kNodeClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& HTMLMediaElement::wrapper_type_info_ =
    V8HTMLMediaElement::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, HTMLMediaElement>::value,
    "HTMLMediaElement does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

// Cross-component trampolines
V8HTMLMediaElement::InstallInterfaceTemplateFuncType V8HTMLMediaElement::install_interface_template_func_ = nullptr;
V8HTMLMediaElement::InstallUnconditionalPropertiesFuncType V8HTMLMediaElement::install_unconditional_props_func_ = nullptr;
V8HTMLMediaElement::InstallContextIndependentPropertiesFuncType V8HTMLMediaElement::install_context_independent_props_func_ = nullptr;
V8HTMLMediaElement::InstallContextDependentPropertiesFuncType V8HTMLMediaElement::install_context_dependent_props_func_ = nullptr;


}  // namespace blink
