// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_html_embed_element.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/binding_security.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/local_window_proxy.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_document.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_constructor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_trustedscripturl_usvstring.h"
#include "third_party/blink/renderer/core/dom/document.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/local_frame.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/custom/ce_reactions_scope.h"
#include "third_party/blink/renderer/core/html/html_embed_element.h"
#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_script_url.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8HTMLEmbedElement::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8HTMLEmbedElement::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8HTMLEmbedElement::InstallInterfaceTemplate,
    nullptr,
    "HTMLEmbedElement",
    V8HTMLElement::GetWrapperTypeInfo(),
    V8HTMLEmbedElement::kThisTag,
    V8HTMLEmbedElement::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kNodeClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& HTMLEmbedElement::wrapper_type_info_ =
    V8HTMLEmbedElement::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, HTMLEmbedElement>::value,
    "HTMLEmbedElement does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

v8::Intercepted V8HTMLEmbedElement::NamedPropertyGetterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_NamedPropertyGetter");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);

// Fast path for when the receiver doesn't have any named properties, possibly
// avoiding any parameter conversions.
if (!bindings::HasAnyNamedProperties(blink_receiver)) {    return v8::Intercepted::kNo;}
// "If the result of running the named property visibility
//  algorithm with property name P and object O is true, then:"
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
auto&& return_value = blink_receiver->AnonymousNamedGetter(blink_property_name);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (return_value.IsEmpty()) {
  // "Return OrdinaryGetOwnProperty(O, P)."
return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
bindings::V8SetReturnValue(info, return_value);
return v8::Intercepted::kYes;
}

v8::Intercepted V8HTMLEmbedElement::NamedPropertySetterCallback(v8::Local<v8::Name> v8_property_name, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_NamedPropertySetter");

// 3.9.2. [[Set]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-set
// step 1. If O and Receiver are the same object, then:
// (V8 calls this callback only when that's the case).
// TODO(https://crbug.com/455600234): remove this CHECK.
CHECK(info.HolderV2() == info.This());
// step 1.2.1. Invoke the named property setter with P and V.

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
auto&& blink_property_value = NativeValueTraits<IDLAny>::ArgumentValue(isolate, 1, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
auto&& return_value = blink_receiver->AnonymousNamedSetter(blink_property_name, blink_property_value);
bindings::V8SetReturnValue(info, return_value);
// HTMLEmbedElement is abusing named properties.
// Do not intercept if the property is not found.
return BlinkInterceptorResultToV8Intercepted(return_value);

}

v8::Intercepted V8HTMLEmbedElement::NamedPropertyDeleterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_NamedPropertyDeleter");

// 3.9.4. [[Delete]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-delete
// step 2. If O supports named properties, O does not implement an interface
//   with the [Global] extended attribute and the result of calling the
//   named property visibility algorithm with property name P and object O
//   is true, then:
//
// There is no easy way to determine whether the named property is visible
// or not.  Just do not intercept and fallback to the default behavior.
return v8::Intercepted::kNo;

}

v8::Intercepted V8HTMLEmbedElement::NamedPropertyDefinerCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_NamedPropertyDefiner");

// HTMLEmbedElement is abusing named properties.
// Do not intercept.  Fallback to OrdinaryDefineOwnProperty.
return v8::Intercepted::kNo;

}

v8::Intercepted V8HTMLEmbedElement::NamedPropertyDescriptorCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_NamedPropertyDescriptor");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
auto intercepted =
    V8HTMLEmbedElement::NamedPropertyGetterCallback(v8_property_name, info);
// "Return OrdinaryGetOwnProperty(O, P)."
if (intercepted == v8::Intercepted::kNo) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "Let desc be a newly created Property Descriptor with no fields."
// "Set desc.[[Value]] to the result of converting value to an ECMAScript
//  value."
// "If O implements an interface with a named property setter, then set
//  desc.[[Writable]] to true, otherwise set it to false."
// "If O implements an interface with the [LegacyUnenumerableNamedProperties]
//  extended attribute, then set desc.[[Enumerable]] to false, otherwise set
//  it to true."
// "Set desc.[[Configurable]] to true."
// "Return desc."
v8::Local<v8::Value> v8_value = info.GetReturnValue().Get();
v8::PropertyDescriptor desc(v8_value, /*writable=*/true);
desc.set_enumerable(false);
desc.set_configurable(true);
bindings::V8SetReturnValue(info, desc);
return v8::Intercepted::kYes;

}

v8::Intercepted V8HTMLEmbedElement::IndexedPropertyGetterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_IndexedPropertyGetter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8HTMLEmbedElement::NamedPropertyGetterCallback(
    V8AtomicString(isolate, blink_property_index), info);

}

v8::Intercepted V8HTMLEmbedElement::IndexedPropertySetterCallback(uint32_t index, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_IndexedPropertySetter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8HTMLEmbedElement::NamedPropertySetterCallback(
    V8AtomicString(isolate, blink_property_index), v8_property_value,
    info);

}

v8::Intercepted V8HTMLEmbedElement::IndexedPropertyDeleterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_IndexedPropertyDeleter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8HTMLEmbedElement::NamedPropertyDeleterCallback(
    V8AtomicString(isolate, blink_property_index), info);

}

v8::Intercepted V8HTMLEmbedElement::IndexedPropertyDefinerCallback(uint32_t index, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_IndexedPropertyDefiner");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8HTMLEmbedElement::NamedPropertyDefinerCallback(
    V8AtomicString(isolate, blink_property_index), v8_property_desc,
    info);

}

v8::Intercepted V8HTMLEmbedElement::IndexedPropertyDescriptorCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_IndexedPropertyDescriptor");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8HTMLEmbedElement::NamedPropertyDescriptorCallback(
    V8AtomicString(isolate, blink_property_index), info);

}


namespace  {

namespace v8_html_embed_element {


void SrcAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_src_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.src.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->src();
static_assert(bindings::IsReturnTypeCompatible<V8UnionTrustedScriptURLOrUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<V8UnionTrustedScriptURLOrUSVString>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void SrcAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_src_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.src.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<V8UnionTrustedScriptURLOrUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSrc(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void TypeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_type_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.type.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kTypeAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TypeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_type_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.type.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kTypeAttr);
}


void WidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_width_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.width.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kWidthAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void WidthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_width_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.width.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kWidthAttr);
}


void HeightAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_height_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.height.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kHeightAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void HeightAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_height_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.height.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kHeightAttr);
}


void AlignAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_align_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.align.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAlignAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AlignAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_align_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.align.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kAlignAttr);
}


void NameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_name_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.name.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetNameAttribute();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void NameAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_name_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.name.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kNameAttr);
}

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_constructor");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
if (V8PerIsolateData::From(isolate)->InWrapperConstructor()) {
  v8::Local<v8::Object> v8_receiver = info.This();
bindings::V8SetReturnValue(info, v8_receiver);
return;
}



// [HTMLConstructor]
V8HTMLConstructor::HtmlConstructor(info, *V8HTMLEmbedElement::GetWrapperTypeInfo(), HTMLElementType::kHTMLEmbedElement);
}

void GetSVGDocumentOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLEmbedElement_getSVGDocument");
BLINK_BINDINGS_TRACE_EVENT("HTMLEmbedElement.getSVGDocument");





// [CheckSecurity=ReturnValue]
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLEmbedElement* blink_receiver = V8HTMLEmbedElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getSVGDocument();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Document>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (!BindingSecurity::ShouldAllowAccessTo(ToLocalDOMWindow(current_context), return_value)) {
  ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
UseCounter::Count(current_execution_context, WebFeature::kCrossOriginHTMLEmbedElementGetSVGDocument);
bindings::V8SetReturnValue(info, nullptr);
return;
}
{
  // [CheckSecurity=ReturnValue]
Frame* blink_frame = blink_receiver->contentWindow()->GetFrame();
DCHECK(IsA<LocalFrame>(blink_frame));
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
if (!blink_frame->IsAttached() && To<LocalFrame>(blink_frame)->WindowProxyMaybeUninitialized(script_state->World())->ContextIfInitialized().IsEmpty()) [[unlikely]] {
  // Don't wrap the return value if its frame is in the process of detaching and
// has already invalidated its v8::Context, as it is not safe to
// re-initialize the v8::Context in that state. Return null instead.
bindings::V8SetReturnValue(info, nullptr);
return;
}
v8::Local<v8::Value> v8_value = ToV8Traits<IDLNullable<Document>>::ToV8(ToScriptState(To<LocalFrame>(blink_frame), script_state->World()),return_value);
bindings::V8SetReturnValue(info, v8_value);
}
}


}  // namespace v8_html_embed_element

using namespace v8_html_embed_element;

}  // namespace 

void V8HTMLEmbedElement::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8HTMLEmbedElement::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(0);
interface_function_template->SetInterfaceName(V8String(isolate, "HTMLEmbedElement"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);



// Named interceptors
instance_template->SetHandler(
    v8::NamedPropertyHandlerConfiguration(
        V8HTMLEmbedElement::NamedPropertyGetterCallback,
        V8HTMLEmbedElement::NamedPropertySetterCallback,
        nullptr,  // query
        V8HTMLEmbedElement::NamedPropertyDeleterCallback,
        nullptr,  // enumerator
        V8HTMLEmbedElement::NamedPropertyDefinerCallback,
        V8HTMLEmbedElement::NamedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        static_cast<v8::PropertyHandlerFlags>(int32_t(v8::PropertyHandlerFlags::kOnlyInterceptStrings) | int32_t(v8::PropertyHandlerFlags::kHasNoSideEffect))));
// Indexed interceptors
instance_template->SetHandler(
    v8::IndexedPropertyHandlerConfiguration(
        V8HTMLEmbedElement::IndexedPropertyGetterCallback,
        V8HTMLEmbedElement::IndexedPropertySetterCallback,
        nullptr,  // query
        V8HTMLEmbedElement::IndexedPropertyDeleterCallback,
        nullptr,  // enumerator
        V8HTMLEmbedElement::IndexedPropertyDefinerCallback,
        V8HTMLEmbedElement::IndexedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        v8::PropertyHandlerFlags::kNone));


InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8HTMLEmbedElement::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"src", SrcAttributeGetCallback, SrcAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"type", TypeAttributeGetCallback, TypeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"width", WidthAttributeGetCallback, WidthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"height", HeightAttributeGetCallback, HeightAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"align", AlignAttributeGetCallback, AlignAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"name", NameAttributeGetCallback, NameAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLEmbedElement", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getSVGDocument", GetSVGDocumentOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLEmbedElement", kOperationTable);
}



}




}  // namespace blink
