// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_GET_HTML_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_GET_HTML_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ShadowRoot;

class CORE_EXPORT GetHTMLOptions : public bindings::InputDictionaryBase {
  
  public:
static GetHTMLOptions* Create() {
  return MakeGarbageCollected<GetHTMLOptions>();
}
static GetHTMLOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GetHTMLOptions>(isolate);
}
static GetHTMLOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GetHTMLOptions();
explicit  GetHTMLOptions(v8::Isolate* isolate);

bool hasSerializableShadowRoots() const {
  return true;
}
bool serializableShadowRoots() const {
  return member_serializable_shadow_roots_;
}
void setSerializableShadowRoots(bool value) {
  member_serializable_shadow_roots_ = value;
}

bool hasShadowRoots() const {
  return true;
}
const HeapVector<Member<ShadowRoot>>& shadowRoots() const {
  return member_shadow_roots_;
}
void setShadowRoots(const HeapVector<Member<ShadowRoot>>& value);
void setShadowRoots(HeapVector<Member<ShadowRoot>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_serializable_shadow_roots_{false};
HeapVector<Member<ShadowRoot>> member_shadow_roots_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_GET_HTML_OPTIONS_H_
