// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_MODIFIER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_MODIFIER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_ui_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT EventModifierInit : public UIEventInit {
  
  public:
static EventModifierInit* Create() {
  return MakeGarbageCollected<EventModifierInit>();
}
static EventModifierInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<EventModifierInit>(isolate);
}
static EventModifierInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  EventModifierInit();
explicit  EventModifierInit(v8::Isolate* isolate);

bool hasAltKey() const {
  return true;
}
bool altKey() const {
  return member_alt_key_;
}
void setAltKey(bool value) {
  member_alt_key_ = value;
}

bool hasCtrlKey() const {
  return true;
}
bool ctrlKey() const {
  return member_ctrl_key_;
}
void setCtrlKey(bool value) {
  member_ctrl_key_ = value;
}

bool hasMetaKey() const {
  return true;
}
bool metaKey() const {
  return member_meta_key_;
}
void setMetaKey(bool value) {
  member_meta_key_ = value;
}

bool hasModifierAltGraph() const {
  return true;
}
bool modifierAltGraph() const {
  return member_modifier_alt_graph_;
}
void setModifierAltGraph(bool value) {
  member_modifier_alt_graph_ = value;
}

bool hasModifierCapsLock() const {
  return true;
}
bool modifierCapsLock() const {
  return member_modifier_caps_lock_;
}
void setModifierCapsLock(bool value) {
  member_modifier_caps_lock_ = value;
}

bool hasModifierFn() const {
  return true;
}
bool modifierFn() const {
  return member_modifier_fn_;
}
void setModifierFn(bool value) {
  member_modifier_fn_ = value;
}

bool hasModifierNumLock() const {
  return true;
}
bool modifierNumLock() const {
  return member_modifier_num_lock_;
}
void setModifierNumLock(bool value) {
  member_modifier_num_lock_ = value;
}

bool hasModifierScrollLock() const {
  return true;
}
bool modifierScrollLock() const {
  return member_modifier_scroll_lock_;
}
void setModifierScrollLock(bool value) {
  member_modifier_scroll_lock_ = value;
}

bool hasModifierSymbol() const {
  return true;
}
bool modifierSymbol() const {
  return member_modifier_symbol_;
}
void setModifierSymbol(bool value) {
  member_modifier_symbol_ = value;
}

bool hasShiftKey() const {
  return true;
}
bool shiftKey() const {
  return member_shift_key_;
}
void setShiftKey(bool value) {
  member_shift_key_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = UIEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_alt_key_{false};
bool member_ctrl_key_{false};
bool member_meta_key_{false};
bool member_modifier_alt_graph_{false};
bool member_modifier_caps_lock_{false};
bool member_modifier_fn_{false};
bool member_modifier_num_lock_{false};
bool member_modifier_scroll_lock_{false};
bool member_modifier_symbol_{false};
bool member_shift_key_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_MODIFIER_INIT_H_
