// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_LISTENER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_LISTENER_H_

#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/callback_interface_base.h"
#include "third_party/blink/renderer/platform/bindings/v8_value_or_script_wrappable_adapter.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Event;

class CORE_EXPORT V8EventListener final : public CallbackInterfaceBase {
  
  public:
static V8EventListener* Create(v8::Local<v8::Object> callback_object) {
  return MakeGarbageCollected<V8EventListener>(callback_object);
}

explicit  V8EventListener(v8::Local<v8::Object> callback_object) : CallbackInterfaceBase(callback_object, kSingleOperation) {
  
}
 ~V8EventListener() override = default;

// NameClient overrides:
const char* GetHumanReadableName() const override;

// Performs "call a user object's operation".
// https://webidl.spec.whatwg.org/#call-a-user-objects-operation
[[nodiscard]] v8::Maybe<void> handleEvent(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Event* arg1_event);

// Performs "call a user object's operation" and then reports an exception
// if any to the global error handler such as DevTools console.
void InvokeAndReportException(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Event* arg1_event);

// Returns true if the callback is runnable, otherwise returns false and
// throws an exception.
enum class IgnorePause {
  kDontIgnore,
  kIgnore,
};
bool IsRunnableOrThrowException(IgnorePause ignore_pause);

// Performs "call a user object's operation".
// https://webidl.spec.whatwg.org/#call-a-user-objects-operation
[[nodiscard]] v8::Maybe<void> InvokeWithoutRunnabilityCheck(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Event* arg1_event);


  
  
  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_LISTENER_H_
