// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_element_internals.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/frozen_array.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_custom_state_set.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_form_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_node_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_shadow_root.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_file_formdata_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_validity_state.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_validity_state_flags.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/core/dom/node_list.h"
#include "third_party/blink/renderer/core/dom/shadow_root.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/fileapi/file.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/custom/ce_reactions_scope.h"
#include "third_party/blink/renderer/core/html/custom/custom_state_set.h"
#include "third_party/blink/renderer/core/html/custom/element_internals.h"
#include "third_party/blink/renderer/core/html/forms/form_data.h"
#include "third_party/blink/renderer/core/html/forms/validity_state.h"
#include "third_party/blink/renderer/core/html/html_element.h"
#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8ElementInternals::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8ElementInternals::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8ElementInternals::InstallInterfaceTemplate,
    nullptr,
    "ElementInternals",
    nullptr,
    V8ElementInternals::kThisTag,
    V8ElementInternals::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& ElementInternals::wrapper_type_info_ =
    V8ElementInternals::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, ElementInternals>::value,
    "ElementInternals inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_element_internals {


void FormAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_form_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.form.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->formForBinding(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<HTMLElement>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void WillValidateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_willValidate_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.willValidate.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->willValidate(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void ValidityAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_validity_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.validity.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->validity(exception_state);
static_assert(bindings::IsReturnTypeCompatible<ValidityState, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ValidationMessageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_validationMessage_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.validationMessage.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->ValidationMessageForBinding(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void LabelsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_labels_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.labels.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->labels(exception_state);
static_assert(bindings::IsReturnTypeCompatible<NodeList, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void StatesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_states_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.states.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kElementInternalsStates);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->states();
static_assert(bindings::IsReturnTypeCompatible<CustomStateSet, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void TypeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_type_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.type.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->type();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TypeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_type_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.type.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setType(arg1_value);

}


void ShadowRootAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_shadowRoot_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.shadowRoot.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kElementInternalsShadowRoot);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shadowRoot();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<ShadowRoot>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void RoleAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_role_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.role.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kRoleAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void RoleAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_role_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.role.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kRoleAttr, arg1_value);

}


void AriaAtomicAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaAtomic_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaAtomic.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaAtomicAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaAtomicAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaAtomic_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaAtomic.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaAtomicAttr, arg1_value);

}


void AriaAutoCompleteAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaAutoComplete_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaAutoComplete.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaAutocompleteAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaAutoCompleteAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaAutoComplete_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaAutoComplete.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaAutocompleteAttr, arg1_value);

}


void AriaBusyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaBusy_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaBusy.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaBusyAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaBusyAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaBusy_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaBusy.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaBusyAttr, arg1_value);

}


void AriaBrailleLabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaBrailleLabel_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaBrailleLabel.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaBraillelabelAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaBrailleLabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaBrailleLabel_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaBrailleLabel.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaBraillelabelAttr, arg1_value);

}


void AriaBrailleRoleDescriptionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaBrailleRoleDescription_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaBrailleRoleDescription.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaBrailleroledescriptionAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaBrailleRoleDescriptionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaBrailleRoleDescription_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaBrailleRoleDescription.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaBrailleroledescriptionAttr, arg1_value);

}


void AriaCheckedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaChecked_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaChecked.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaCheckedAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaCheckedAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaChecked_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaChecked.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaCheckedAttr, arg1_value);

}


void AriaColCountAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColCount_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColCount.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaColcountAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaColCountAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColCount_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColCount.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaColcountAttr, arg1_value);

}


void AriaColIndexAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColIndex_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColIndex.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaColindexAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaColIndexAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColIndex_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColIndex.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaColindexAttr, arg1_value);

}


void AriaColIndexTextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColIndexText_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColIndexText.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaColindextextAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaColIndexTextAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColIndexText_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColIndexText.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaColindextextAttr, arg1_value);

}


void AriaColSpanAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColSpan_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColSpan.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaColspanAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaColSpanAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaColSpan_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaColSpan.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaColspanAttr, arg1_value);

}


void AriaCurrentAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaCurrent_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaCurrent.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaCurrentAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaCurrentAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaCurrent_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaCurrent.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaCurrentAttr, arg1_value);

}


void AriaDescriptionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDescription_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDescription.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaDescriptionAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaDescriptionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDescription_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDescription.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaDescriptionAttr, arg1_value);

}


void AriaDisabledAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDisabled_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDisabled.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaDisabledAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaDisabledAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDisabled_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDisabled.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaDisabledAttr, arg1_value);

}


void AriaExpandedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaExpanded_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaExpanded.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaExpandedAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaExpandedAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaExpanded_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaExpanded.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaExpandedAttr, arg1_value);

}


void AriaHasPopupAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaHasPopup_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaHasPopup.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaHaspopupAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaHasPopupAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaHasPopup_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaHasPopup.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaHaspopupAttr, arg1_value);

}


void AriaHiddenAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaHidden_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaHidden.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaHiddenAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaHiddenAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaHidden_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaHidden.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaHiddenAttr, arg1_value);

}


void AriaInvalidAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaInvalid_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaInvalid.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaInvalidAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaInvalidAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaInvalid_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaInvalid.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaInvalidAttr, arg1_value);

}


void AriaKeyShortcutsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaKeyShortcuts_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaKeyShortcuts.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaKeyshortcutsAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaKeyShortcutsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaKeyShortcuts_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaKeyShortcuts.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaKeyshortcutsAttr, arg1_value);

}


void AriaLabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLabel_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLabel.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaLabelAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaLabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLabel_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLabel.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaLabelAttr, arg1_value);

}


void AriaLevelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLevel_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLevel.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaLevelAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaLevelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLevel_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLevel.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaLevelAttr, arg1_value);

}


void AriaLiveAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLive_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLive.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaLiveAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaLiveAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLive_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLive.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaLiveAttr, arg1_value);

}


void AriaModalAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaModal_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaModal.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaModalAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaModalAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaModal_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaModal.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaModalAttr, arg1_value);

}


void AriaMultiLineAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaMultiLine_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaMultiLine.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaMultilineAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaMultiLineAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaMultiLine_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaMultiLine.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaMultilineAttr, arg1_value);

}


void AriaMultiSelectableAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaMultiSelectable_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaMultiSelectable.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaMultiselectableAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaMultiSelectableAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaMultiSelectable_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaMultiSelectable.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaMultiselectableAttr, arg1_value);

}


void AriaOrientationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaOrientation_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaOrientation.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaOrientationAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaOrientationAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaOrientation_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaOrientation.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaOrientationAttr, arg1_value);

}


void AriaPlaceholderAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaPlaceholder_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaPlaceholder.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaPlaceholderAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaPlaceholderAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaPlaceholder_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaPlaceholder.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaPlaceholderAttr, arg1_value);

}


void AriaPosInSetAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaPosInSet_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaPosInSet.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaPosinsetAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaPosInSetAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaPosInSet_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaPosInSet.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaPosinsetAttr, arg1_value);

}


void AriaPressedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaPressed_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaPressed.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaPressedAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaPressedAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaPressed_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaPressed.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaPressedAttr, arg1_value);

}


void AriaReadOnlyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaReadOnly_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaReadOnly.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaReadonlyAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaReadOnlyAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaReadOnly_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaReadOnly.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaReadonlyAttr, arg1_value);

}


void AriaRelevantAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRelevant_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRelevant.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRelevantAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRelevantAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRelevant_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRelevant.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRelevantAttr, arg1_value);

}


void AriaRequiredAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRequired_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRequired.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRequiredAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRequiredAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRequired_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRequired.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRequiredAttr, arg1_value);

}


void AriaRoleDescriptionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRoleDescription_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRoleDescription.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRoledescriptionAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRoleDescriptionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRoleDescription_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRoleDescription.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRoledescriptionAttr, arg1_value);

}


void AriaRowCountAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowCount_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowCount.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRowcountAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRowCountAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowCount_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowCount.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRowcountAttr, arg1_value);

}


void AriaRowIndexAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowIndex_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowIndex.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRowindexAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRowIndexAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowIndex_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowIndex.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRowindexAttr, arg1_value);

}


void AriaRowIndexTextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowIndexText_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowIndexText.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRowindextextAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRowIndexTextAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowIndexText_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowIndexText.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRowindextextAttr, arg1_value);

}


void AriaRowSpanAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowSpan_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowSpan.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaRowspanAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaRowSpanAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaRowSpan_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaRowSpan.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaRowspanAttr, arg1_value);

}


void AriaSelectedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaSelected_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaSelected.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaSelectedAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaSelectedAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaSelected_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaSelected.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaSelectedAttr, arg1_value);

}


void AriaSetSizeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaSetSize_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaSetSize.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaSetsizeAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaSetSizeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaSetSize_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaSetSize.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaSetsizeAttr, arg1_value);

}


void AriaSortAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaSort_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaSort.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaSortAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaSortAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaSort_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaSort.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaSortAttr, arg1_value);

}


void AriaValueMaxAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueMax_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueMax.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaValuemaxAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaValueMaxAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueMax_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueMax.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaValuemaxAttr, arg1_value);

}


void AriaValueMinAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueMin_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueMin.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaValueminAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaValueMinAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueMin_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueMin.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaValueminAttr, arg1_value);

}


void AriaValueNowAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueNow_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueNow.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaValuenowAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaValueNowAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueNow_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueNow.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaValuenowAttr, arg1_value);

}


void AriaValueTextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueText_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueText.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaValuetextAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaValueTextAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaValueText_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaValueText.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaValuetextAttr, arg1_value);

}


void AriaVirtualContentAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaVirtualContent_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaVirtualContent.get");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAriaVirtualcontentAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void AriaVirtualContentAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaVirtualContent_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaVirtualContent.set");
v8::Isolate* isolate = info.GetIsolate();
// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kAriaAttributeReflection);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kAriaVirtualcontentAttr, arg1_value);

}


void AriaActiveDescendantElementAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaActiveDescendantElement_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaActiveDescendantElement.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaActiveDescendantElement_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetElementAttribute(html_names::kAriaActivedescendantAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Element>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void AriaActiveDescendantElementAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaActiveDescendantElement_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaActiveDescendantElement.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaActiveDescendantElement_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<Element>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->SetElementAttribute(html_names::kAriaActivedescendantAttr, arg1_value);

}


void AriaControlsElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaControlsElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaControlsElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaControlsElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaControlsElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaControlsElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaControlsElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaControlsElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaControlsElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaControlsElements(arg1_value);

}


void AriaDescribedByElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDescribedByElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDescribedByElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaDescribedByElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaDescribedByElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaDescribedByElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDescribedByElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDescribedByElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaDescribedByElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaDescribedByElements(arg1_value);

}


void AriaDetailsElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDetailsElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDetailsElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaDetailsElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaDetailsElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaDetailsElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaDetailsElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaDetailsElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaDetailsElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaDetailsElements(arg1_value);

}


void AriaErrorMessageElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaErrorMessageElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaErrorMessageElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaErrorMessageElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaErrorMessageElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaErrorMessageElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaErrorMessageElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaErrorMessageElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaErrorMessageElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaErrorMessageElements(arg1_value);

}


void AriaFlowToElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaFlowToElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaFlowToElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaFlowToElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaFlowToElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaFlowToElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaFlowToElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaFlowToElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaFlowToElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaFlowToElements(arg1_value);

}


void AriaLabelledByElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLabelledByElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLabelledByElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaLabelledByElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaLabelledByElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaLabelledByElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaLabelledByElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaLabelledByElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaLabelledByElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaLabelledByElements(arg1_value);

}


void AriaOwnsElementsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaOwnsElements_Getter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaOwnsElements.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaOwnsElements_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->ariaOwnsElements();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLArray<Element>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLArray<Element>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void AriaOwnsElementsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_ariaOwnsElements_Setter");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.ariaOwnsElements.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8ElementInternals_AriaOwnsElements_AttributeSetter);

ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLArray<Element>>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAriaOwnsElements(arg1_value);

}

void CheckValidityOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_checkValidity");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.checkValidity");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->checkValidity(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void ReportValidityOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_reportValidity");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.reportValidity");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->reportValidity(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void SetFormValueOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_setFormValue");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.setFormValue");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_value = NativeValueTraits<IDLNullable<V8UnionFileOrFormDataOrUSVString>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  blink_receiver->setFormValue(arg1_value, exception_state);
break;
}
auto&& arg2_state = NativeValueTraits<IDLNullable<V8UnionFileOrFormDataOrUSVString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFormValue(arg1_value, arg2_state, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetValidityOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ElementInternals_setValidity");
BLINK_BINDINGS_TRACE_EVENT("ElementInternals.setValidity");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
ElementInternals* blink_receiver = V8ElementInternals::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_flags = NativeValueTraits<ValidityStateFlags>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  blink_receiver->setValidity(arg1_flags, exception_state);
break;
}
auto&& arg2_message = NativeValueTraits<IDLOptional<IDLString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->setValidity(arg1_flags, arg2_message, exception_state);
break;
}
auto&& arg3_anchor = NativeValueTraits<HTMLElement>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setValidity(arg1_flags, arg2_message, arg3_anchor, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_element_internals

using namespace v8_element_internals;

}  // namespace 

void V8ElementInternals::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8ElementInternals::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8ElementInternals::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"form", FormAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"willValidate", WillValidateAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"validity", ValidityAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"validationMessage", ValidationMessageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"labels", LabelsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"states", StatesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"shadowRoot", ShadowRootAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"role", RoleAttributeGetCallback, RoleAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaAtomic", AriaAtomicAttributeGetCallback, AriaAtomicAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaAutoComplete", AriaAutoCompleteAttributeGetCallback, AriaAutoCompleteAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaBusy", AriaBusyAttributeGetCallback, AriaBusyAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaBrailleLabel", AriaBrailleLabelAttributeGetCallback, AriaBrailleLabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaBrailleRoleDescription", AriaBrailleRoleDescriptionAttributeGetCallback, AriaBrailleRoleDescriptionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaChecked", AriaCheckedAttributeGetCallback, AriaCheckedAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaColCount", AriaColCountAttributeGetCallback, AriaColCountAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaColIndex", AriaColIndexAttributeGetCallback, AriaColIndexAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaColSpan", AriaColSpanAttributeGetCallback, AriaColSpanAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaCurrent", AriaCurrentAttributeGetCallback, AriaCurrentAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaDescription", AriaDescriptionAttributeGetCallback, AriaDescriptionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaDisabled", AriaDisabledAttributeGetCallback, AriaDisabledAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaExpanded", AriaExpandedAttributeGetCallback, AriaExpandedAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaHasPopup", AriaHasPopupAttributeGetCallback, AriaHasPopupAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaHidden", AriaHiddenAttributeGetCallback, AriaHiddenAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaInvalid", AriaInvalidAttributeGetCallback, AriaInvalidAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaKeyShortcuts", AriaKeyShortcutsAttributeGetCallback, AriaKeyShortcutsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaLabel", AriaLabelAttributeGetCallback, AriaLabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaLevel", AriaLevelAttributeGetCallback, AriaLevelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaLive", AriaLiveAttributeGetCallback, AriaLiveAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaModal", AriaModalAttributeGetCallback, AriaModalAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaMultiLine", AriaMultiLineAttributeGetCallback, AriaMultiLineAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaMultiSelectable", AriaMultiSelectableAttributeGetCallback, AriaMultiSelectableAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaOrientation", AriaOrientationAttributeGetCallback, AriaOrientationAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaPlaceholder", AriaPlaceholderAttributeGetCallback, AriaPlaceholderAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaPosInSet", AriaPosInSetAttributeGetCallback, AriaPosInSetAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaPressed", AriaPressedAttributeGetCallback, AriaPressedAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaReadOnly", AriaReadOnlyAttributeGetCallback, AriaReadOnlyAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRelevant", AriaRelevantAttributeGetCallback, AriaRelevantAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRequired", AriaRequiredAttributeGetCallback, AriaRequiredAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRoleDescription", AriaRoleDescriptionAttributeGetCallback, AriaRoleDescriptionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRowCount", AriaRowCountAttributeGetCallback, AriaRowCountAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRowIndex", AriaRowIndexAttributeGetCallback, AriaRowIndexAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRowSpan", AriaRowSpanAttributeGetCallback, AriaRowSpanAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaSelected", AriaSelectedAttributeGetCallback, AriaSelectedAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaSetSize", AriaSetSizeAttributeGetCallback, AriaSetSizeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaSort", AriaSortAttributeGetCallback, AriaSortAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaValueMax", AriaValueMaxAttributeGetCallback, AriaValueMaxAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaValueMin", AriaValueMinAttributeGetCallback, AriaValueMinAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaValueNow", AriaValueNowAttributeGetCallback, AriaValueNowAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaValueText", AriaValueTextAttributeGetCallback, AriaValueTextAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"checkValidity", CheckValidityOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"reportValidity", ReportValidityOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setFormValue", SetFormValueOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setValidity", SetValidityOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kOperationTable);
}



}

void V8ElementInternals::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::ElementInternalsDotTypeEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"type", TypeAttributeGetCallback, TypeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kAttributeTable);
}
if (RuntimeEnabledFeatures::AriaRowColIndexTextEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ariaColIndexText", AriaColIndexTextAttributeGetCallback, AriaColIndexTextAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaRowIndexText", AriaRowIndexTextAttributeGetCallback, AriaRowIndexTextAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kAttributeTable);
}
if (RuntimeEnabledFeatures::AccessibilityAriaVirtualContentEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ariaVirtualContent", AriaVirtualContentAttributeGetCallback, AriaVirtualContentAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kAttributeTable);
}
if (RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ariaActiveDescendantElement", AriaActiveDescendantElementAttributeGetCallback, AriaActiveDescendantElementAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaControlsElements", AriaControlsElementsAttributeGetCallback, AriaControlsElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaDescribedByElements", AriaDescribedByElementsAttributeGetCallback, AriaDescribedByElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaDetailsElements", AriaDetailsElementsAttributeGetCallback, AriaDetailsElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaErrorMessageElements", AriaErrorMessageElementsAttributeGetCallback, AriaErrorMessageElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaFlowToElements", AriaFlowToElementsAttributeGetCallback, AriaFlowToElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"ariaLabelledByElements", AriaLabelledByElementsAttributeGetCallback, AriaLabelledByElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kAttributeTable);
}
if (RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesEnabled() && RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesAriaOwnsEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ariaOwnsElements", AriaOwnsElementsAttributeGetCallback, AriaOwnsElementsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ElementInternals", kAttributeTable);
}






}



}  // namespace blink
