// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_POINT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_POINT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT DOMPointInit : public bindings::DictionaryBase {
  
  public:
static DOMPointInit* Create() {
  return MakeGarbageCollected<DOMPointInit>();
}
static DOMPointInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DOMPointInit>(isolate);
}
static DOMPointInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DOMPointInit();
explicit  DOMPointInit(v8::Isolate* isolate);

bool hasW() const {
  return true;
}
double w() const {
  return member_w_;
}
void setW(double value) {
  member_w_ = value;
}

bool hasX() const {
  return true;
}
double x() const {
  return member_x_;
}
void setX(double value) {
  member_x_ = value;
}

bool hasY() const {
  return true;
}
double y() const {
  return member_y_;
}
void setY(double value) {
  member_y_ = value;
}

bool hasZ() const {
  return true;
}
double z() const {
  return member_z_;
}
void setZ(double value) {
  member_z_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



double member_w_{1};
double member_x_{0};
double member_y_{0};
double member_z_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_POINT_INIT_H_
