// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_dedicated_worker_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_global_scope.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/workers/dedicated_worker_global_scope.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8DedicatedWorkerGlobalScope::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsDedicatedWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8DedicatedWorkerGlobalScope::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8DedicatedWorkerGlobalScope::InstallInterfaceTemplate,
    V8DedicatedWorkerGlobalScope::InstallContextDependentProperties,
    "DedicatedWorkerGlobalScope",
    V8WorkerGlobalScope::GetWrapperTypeInfo(),
    V8DedicatedWorkerGlobalScope::kThisTag,
    V8DedicatedWorkerGlobalScope::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& DedicatedWorkerGlobalScope::wrapper_type_info_ =
    V8DedicatedWorkerGlobalScope::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, DedicatedWorkerGlobalScope>::value,
    "DedicatedWorkerGlobalScope does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

// Cross-component trampolines
V8DedicatedWorkerGlobalScope::InstallInterfaceTemplateFuncType V8DedicatedWorkerGlobalScope::install_interface_template_func_ = nullptr;
V8DedicatedWorkerGlobalScope::InstallUnconditionalPropertiesFuncType V8DedicatedWorkerGlobalScope::install_unconditional_props_func_ = nullptr;
V8DedicatedWorkerGlobalScope::InstallContextIndependentPropertiesFuncType V8DedicatedWorkerGlobalScope::install_context_independent_props_func_ = nullptr;
V8DedicatedWorkerGlobalScope::InstallContextDependentPropertiesFuncType V8DedicatedWorkerGlobalScope::install_context_dependent_props_func_ = nullptr;


}  // namespace blink
