// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_custom_element_attribute_changed_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8CustomElementAttributeChangedCallback::GetHumanReadableName() const {
  return "V8CustomElementAttributeChangedCallback";
}

v8::Maybe<void> V8CustomElementAttributeChangedCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const String& arg1_local_name, const String& arg2_old_value, const String& arg3_new_value, const String& arg4_attr_namespace) {
  const char* const class_like_name = "CustomElementAttributeChangedCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<void>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<void>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}
v8::Local<v8::Value> argv_arr[4];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_local_name;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_local_name = ToV8Traits<IDLString>::ToV8(script_state, arg1_local_name);
argv[0] = v8_arg1_local_name;
v8::Local<v8::Value> v8_arg2_old_value;
v8_arg2_old_value = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, arg2_old_value);
argv[1] = v8_arg2_old_value;
v8::Local<v8::Value> v8_arg3_new_value;
v8_arg3_new_value = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, arg3_new_value);
argv[2] = v8_arg3_new_value;
v8::Local<v8::Value> v8_arg4_attr_namespace;
v8_arg4_attr_namespace = ToV8Traits<IDLNullable<IDLUSVString>>::ToV8(script_state, arg4_attr_namespace);
argv[3] = v8_arg4_attr_namespace;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}

v8::Maybe<void> V8CustomElementAttributeChangedCallback::Construct(const String& arg1_local_name, const String& arg2_old_value, const String& arg3_new_value, const String& arg4_attr_namespace) {
  const char* const class_like_name = "CustomElementAttributeChangedCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<void>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<void>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}
v8::Local<v8::Value> argv_arr[4];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_local_name;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_local_name = ToV8Traits<IDLString>::ToV8(script_state, arg1_local_name);
argv[0] = v8_arg1_local_name;
v8::Local<v8::Value> v8_arg2_old_value;
v8_arg2_old_value = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, arg2_old_value);
argv[1] = v8_arg2_old_value;
v8::Local<v8::Value> v8_arg3_new_value;
v8_arg3_new_value = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, arg3_new_value);
argv[2] = v8_arg3_new_value;
v8::Local<v8::Value> v8_arg4_attr_namespace;
v8_arg4_attr_namespace = ToV8Traits<IDLNullable<IDLUSVString>>::ToV8(script_state, arg4_attr_namespace);
argv[3] = v8_arg4_attr_namespace;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}

void V8CustomElementAttributeChangedCallback::InvokeAndReportException(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const String& arg1_local_name, const String& arg2_old_value, const String& arg3_new_value, const String& arg4_attr_namespace) {
  v8::Isolate* isolate = GetIsolate();
v8::TryCatch try_catch(isolate);
try_catch.SetVerbose(true);

std::ignore = Invoke(arg0_receiver, arg1_local_name, arg2_old_value, arg3_new_value, arg4_attr_namespace);
}



}  // namespace blink
