// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_css_style_rule.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_rule.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_rule_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_style_declaration.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_style_property_map.h"
#include "third_party/blink/renderer/core/css/css_rule_list.h"
#include "third_party/blink/renderer/core/css/css_style_declaration.h"
#include "third_party/blink/renderer/core/css/css_style_rule.h"
#include "third_party/blink/renderer/core/css/cssom/style_property_map.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8CSSStyleRule::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8CSSStyleRule::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8CSSStyleRule::InstallInterfaceTemplate,
    nullptr,
    "CSSStyleRule",
    V8CSSRule::GetWrapperTypeInfo(),
    V8CSSStyleRule::kThisTag,
    V8CSSStyleRule::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& CSSStyleRule::wrapper_type_info_ =
    V8CSSStyleRule::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, CSSStyleRule>::value,
    "CSSStyleRule inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_css_style_rule {


void SelectorTextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_selectorText_Getter");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.selectorText.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->selectorText();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void SelectorTextAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_selectorText_Setter");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.selectorText.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSelectorText(execution_context, arg1_value);

}


void StyleAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_style_Getter");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.style.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->style();
static_assert(bindings::IsReturnTypeCompatible<CSSStyleDeclaration, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void StyleAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_style_Setter");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.style.set");

// [PutForwards]
v8::Local<v8::Value> target;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "style";
if (!v8_receiver->Get(current_context, V8AtomicString(isolate, property_name)).ToLocal(&target)) {
  return;
}
if (!target->IsObject()) {
  V8ThrowException::ThrowTypeError(isolate, "The attribute value is not an object");
return;
}
bool did_set;
v8::Local<v8::Value> v8_property_value = info[0];
if (!target.As<v8::Object>()->Set(current_context, V8AtomicString(isolate, "cssText"), v8_property_value).To(&did_set)) {
  return;
}
return;
}


void StyleMapAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_styleMap_Getter");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.styleMap.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCSSTypedOMStylePropertyMap);


v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->styleMap();
static_assert(bindings::IsReturnTypeCompatible<StylePropertyMap, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void CSSRulesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_cssRules_Getter");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.cssRules.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->cssRules();
static_assert(bindings::IsReturnTypeCompatible<CSSRuleList, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}


void DeleteRuleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_deleteRule");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.deleteRule");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteRule(arg1_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void InsertRuleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_CSSStyleRule_insertRule");
BLINK_BINDINGS_TRACE_EVENT("CSSStyleRule.insertRule");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
CSSStyleRule* blink_receiver = V8CSSStyleRule::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
ExceptionState exception_state(isolate);
auto&& arg1_rule = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_index{0};
if (!info[1]->IsUndefined()) {
  arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->insertRule(execution_context, arg1_rule, arg2_index, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}


}  // namespace v8_css_style_rule

using namespace v8_css_style_rule;

}  // namespace 

void V8CSSStyleRule::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8CSSStyleRule::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8CSSStyleRule::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"selectorText", SelectorTextAttributeGetCallback, SelectorTextAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"style", StyleAttributeGetCallback, StyleAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"styleMap", StyleMapAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"cssRules", CSSRulesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "CSSStyleRule", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"deleteRule", DeleteRuleOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"insertRule", InsertRuleOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "CSSStyleRule", kOperationTable);
}



}




}  // namespace blink
