// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_NUMERIC_TYPE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_NUMERIC_TYPE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_base_type.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CSSNumericType : public bindings::DictionaryBase {
  
  public:
static CSSNumericType* Create() {
  return MakeGarbageCollected<CSSNumericType>();
}
static CSSNumericType* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CSSNumericType>(isolate);
}
static CSSNumericType* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CSSNumericType();
explicit  CSSNumericType(v8::Isolate* isolate);

bool hasAngle() const {
  return has_angle_;
}
int32_t angle() const {
  DCHECK(hasAngle());
return member_angle_;
}
int32_t getAngleOr(int32_t fallback_value) const {
  if (!hasAngle()) {
  return fallback_value;
}
return member_angle_;
}
void setAngle(int32_t value) {
  member_angle_ = value;
has_angle_ = true;
}

bool hasFlex() const {
  return has_flex_;
}
int32_t flex() const {
  DCHECK(hasFlex());
return member_flex_;
}
int32_t getFlexOr(int32_t fallback_value) const {
  if (!hasFlex()) {
  return fallback_value;
}
return member_flex_;
}
void setFlex(int32_t value) {
  member_flex_ = value;
has_flex_ = true;
}

bool hasFrequency() const {
  return has_frequency_;
}
int32_t frequency() const {
  DCHECK(hasFrequency());
return member_frequency_;
}
int32_t getFrequencyOr(int32_t fallback_value) const {
  if (!hasFrequency()) {
  return fallback_value;
}
return member_frequency_;
}
void setFrequency(int32_t value) {
  member_frequency_ = value;
has_frequency_ = true;
}

bool hasLength() const {
  return has_length_;
}
int32_t length() const {
  DCHECK(hasLength());
return member_length_;
}
int32_t getLengthOr(int32_t fallback_value) const {
  if (!hasLength()) {
  return fallback_value;
}
return member_length_;
}
void setLength(int32_t value) {
  member_length_ = value;
has_length_ = true;
}

bool hasPercent() const {
  return has_percent_;
}
int32_t percent() const {
  DCHECK(hasPercent());
return member_percent_;
}
int32_t getPercentOr(int32_t fallback_value) const {
  if (!hasPercent()) {
  return fallback_value;
}
return member_percent_;
}
void setPercent(int32_t value) {
  member_percent_ = value;
has_percent_ = true;
}

bool hasPercentHint() const {
  return has_percent_hint_;
}
V8CSSNumericBaseType percentHint() const {
  DCHECK(hasPercentHint());
return member_percent_hint_;
}
V8CSSNumericBaseType getPercentHintOr(V8CSSNumericBaseType fallback_value) const {
  if (!hasPercentHint()) {
  return fallback_value;
}
return member_percent_hint_;
}
void setPercentHint(V8CSSNumericBaseType value) {
  member_percent_hint_ = value;
has_percent_hint_ = true;
}
void setPercentHint(V8CSSNumericBaseType::Enum value) {
  member_percent_hint_ = V8CSSNumericBaseType(value);
has_percent_hint_ = true;
}

bool hasResolution() const {
  return has_resolution_;
}
int32_t resolution() const {
  DCHECK(hasResolution());
return member_resolution_;
}
int32_t getResolutionOr(int32_t fallback_value) const {
  if (!hasResolution()) {
  return fallback_value;
}
return member_resolution_;
}
void setResolution(int32_t value) {
  member_resolution_ = value;
has_resolution_ = true;
}

bool hasTime() const {
  return has_time_;
}
int32_t time() const {
  DCHECK(hasTime());
return member_time_;
}
int32_t getTimeOr(int32_t fallback_value) const {
  if (!hasTime()) {
  return fallback_value;
}
return member_time_;
}
void setTime(int32_t value) {
  member_time_ = value;
has_time_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_angle_ = false;
bool has_flex_ = false;
bool has_frequency_ = false;
bool has_length_ = false;
bool has_percent_ = false;
bool has_percent_hint_ = false;
bool has_resolution_ = false;
bool has_time_ = false;

int32_t member_angle_;
int32_t member_flex_;
int32_t member_frequency_;
int32_t member_length_;
int32_t member_percent_;
V8CSSNumericBaseType member_percent_hint_{static_cast<V8CSSNumericBaseType::Enum>(0)};
int32_t member_resolution_;
int32_t member_time_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_NUMERIC_TYPE_H_
