// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_computed_effect_timing.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_cssnumericvalue_double.h"
#include "third_party/blink/renderer/core/css/cssom/css_numeric_value.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"activeDuration",
"currentIteration",
"endTime",
"localTime",
"progress",
};


}  // namespace 

ComputedEffectTiming* ComputedEffectTiming::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ComputedEffectTiming* dictionary = MakeGarbageCollected<ComputedEffectTiming>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ComputedEffectTiming";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ComputedEffectTiming::ComputedEffectTiming() {
  
}

 ComputedEffectTiming::ComputedEffectTiming(v8::Isolate* isolate) : EffectTiming(isolate) {
  
}





































void ComputedEffectTiming::Trace(Visitor* visitor) const {
  visitor->Trace(member_active_duration_);
visitor->Trace(member_end_time_);
visitor->Trace(member_local_time_);
EffectTiming::Trace(visitor);
}

void ComputedEffectTiming::FillTemplateProperties(Vector<std::string_view>& properties) const {
  EffectTiming::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ComputedEffectTiming::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  EffectTiming::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasActiveDuration()) {
  values[0] = ToV8Traits<V8UnionCSSNumericValueOrDouble>::ToV8(script_state, member_active_duration_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasCurrentIteration()) {
  values[1] = ToV8Traits<IDLNullable<IDLUnrestrictedDouble>>::ToV8(script_state, member_current_iteration_);
DCHECK(!values[1].IsEmpty());
}
if (hasEndTime()) {
  values[2] = ToV8Traits<V8UnionCSSNumericValueOrDouble>::ToV8(script_state, member_end_time_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasLocalTime()) {
  values[3] = ToV8Traits<IDLNullable<V8UnionCSSNumericValueOrDouble>>::ToV8(script_state, member_local_time_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasProgress()) {
  values[4] = ToV8Traits<IDLNullable<IDLDouble>>::ToV8(script_state, member_progress_);
DCHECK(!values[4].IsEmpty());
}
}

const void* ComputedEffectTiming::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ComputedEffectTiming::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ComputedEffectTiming::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EffectTiming::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "ComputedEffectTiming";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("activeDuration");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_active_duration_, member_active_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("currentIteration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLUnrestrictedDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_current_iteration_, member_current_iteration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("endTime");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionCSSNumericValueOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_end_time_, member_end_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("localTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<V8UnionCSSNumericValueOrDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_local_time_, member_local_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("progress");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_progress_, member_progress_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ComputedEffectTiming::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
