// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CHARACTER_BOUNDS_UPDATE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CHARACTER_BOUNDS_UPDATE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CharacterBoundsUpdateEventInit : public EventInit {
  
  public:
static CharacterBoundsUpdateEventInit* Create() {
  return MakeGarbageCollected<CharacterBoundsUpdateEventInit>();
}
static CharacterBoundsUpdateEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CharacterBoundsUpdateEventInit>(isolate);
}
static CharacterBoundsUpdateEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CharacterBoundsUpdateEventInit();
explicit  CharacterBoundsUpdateEventInit(v8::Isolate* isolate);

bool hasRangeEnd() const {
  return has_range_end_;
}
uint32_t rangeEnd() const {
  DCHECK(hasRangeEnd());
return member_range_end_;
}
uint32_t getRangeEndOr(uint32_t fallback_value) const {
  if (!hasRangeEnd()) {
  return fallback_value;
}
return member_range_end_;
}
void setRangeEnd(uint32_t value) {
  member_range_end_ = value;
has_range_end_ = true;
}

bool hasRangeStart() const {
  return has_range_start_;
}
uint32_t rangeStart() const {
  DCHECK(hasRangeStart());
return member_range_start_;
}
uint32_t getRangeStartOr(uint32_t fallback_value) const {
  if (!hasRangeStart()) {
  return fallback_value;
}
return member_range_start_;
}
void setRangeStart(uint32_t value) {
  member_range_start_ = value;
has_range_start_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_range_end_ = false;
bool has_range_start_ = false;

uint32_t member_range_end_;
uint32_t member_range_start_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CHARACTER_BOUNDS_UPDATE_EVENT_INIT_H_
