// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_HIT_TEST_RECT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_HIT_TEST_RECT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT CanvasHitTestRect : public bindings::InputDictionaryBase {
  
  public:
static CanvasHitTestRect* Create() {
  return MakeGarbageCollected<CanvasHitTestRect>();
}
static CanvasHitTestRect* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanvasHitTestRect>(isolate);
}
static CanvasHitTestRect* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanvasHitTestRect();
explicit  CanvasHitTestRect(v8::Isolate* isolate);

bool hasHeight() const {
  return has_height_;
}
const std::optional<double>& height() const {
  DCHECK(hasHeight());
return member_height_;
}
std::optional<double> getHeightOr(const std::optional<double>& fallback_value) const {
  if (!hasHeight()) {
  return fallback_value;
}
return member_height_;
}
void setHeight(const std::optional<double>& value) {
  member_height_ = value;
has_height_ = true;
}
void setHeight(double value) {
  member_height_ = value;
has_height_ = true;
}

bool hasWidth() const {
  return has_width_;
}
const std::optional<double>& width() const {
  DCHECK(hasWidth());
return member_width_;
}
std::optional<double> getWidthOr(const std::optional<double>& fallback_value) const {
  if (!hasWidth()) {
  return fallback_value;
}
return member_width_;
}
void setWidth(const std::optional<double>& value) {
  member_width_ = value;
has_width_ = true;
}
void setWidth(double value) {
  member_width_ = value;
has_width_ = true;
}

bool hasX() const {
  return has_x_;
}
double x() const {
  DCHECK(hasX());
return member_x_;
}
double getXOr(double fallback_value) const {
  if (!hasX()) {
  return fallback_value;
}
return member_x_;
}
void setX(double value) {
  member_x_ = value;
has_x_ = true;
}

bool hasY() const {
  return has_y_;
}
double y() const {
  DCHECK(hasY());
return member_y_;
}
double getYOr(double fallback_value) const {
  if (!hasY()) {
  return fallback_value;
}
return member_y_;
}
void setY(double value) {
  member_y_ = value;
has_y_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_height_ = false;
bool has_width_ = false;
bool has_x_ = false;
bool has_y_ = false;

std::optional<double> member_height_;
std::optional<double> member_width_;
double member_x_;
double member_y_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_HIT_TEST_RECT_H_
