// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_high_dynamic_range_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_smpte_st_2086_metadata.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"agtm",
"mode",
"smpteSt2086Metadata",
};


}  // namespace 

CanvasHighDynamicRangeOptions* CanvasHighDynamicRangeOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CanvasHighDynamicRangeOptions* dictionary = MakeGarbageCollected<CanvasHighDynamicRangeOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CanvasHighDynamicRangeOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CanvasHighDynamicRangeOptions::CanvasHighDynamicRangeOptions() {
  
}

 CanvasHighDynamicRangeOptions::CanvasHighDynamicRangeOptions(v8::Isolate* isolate) {
  
}



String CanvasHighDynamicRangeOptions::getAgtmOr(const String& fallback_value) const {
  if (!hasAgtm()) {
  return fallback_value;
}
return member_agtm_;
}

String CanvasHighDynamicRangeOptions::getAgtmOr(String&& fallback_value) const {
  if (!hasAgtm()) {
  return std::move(fallback_value);
}
return member_agtm_;
}

void CanvasHighDynamicRangeOptions::setAgtm(const String& value) {
  member_agtm_ = value;
has_agtm_ = true;
}

void CanvasHighDynamicRangeOptions::setAgtm(String&& value) {
  member_agtm_ = std::move(value);
has_agtm_ = true;
}















void CanvasHighDynamicRangeOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_smpte_st_2086_metadata_);
bindings::InputDictionaryBase::Trace(visitor);
}

void CanvasHighDynamicRangeOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CanvasHighDynamicRangeOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("agtm");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_agtm_, member_agtm_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mode");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8CanvasHighDynamicRangeMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("smpteSt2086Metadata");
if (!bindings::GetDictionaryMemberFromV8Object<CanvasSmpteSt2086Metadata, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_smpte_st_2086_metadata_, member_smpte_st_2086_metadata_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CanvasHighDynamicRangeOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
