// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_ELEMENT_HIT_TEST_REGION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_ELEMENT_HIT_TEST_REGION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CanvasHitTestRect;
class Element;
class ExceptionState;

class CORE_EXPORT CanvasElementHitTestRegion : public bindings::InputDictionaryBase {
  
  public:
static CanvasElementHitTestRegion* Create() {
  return MakeGarbageCollected<CanvasElementHitTestRegion>();
}
static CanvasElementHitTestRegion* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanvasElementHitTestRegion>(isolate);
}
static CanvasElementHitTestRegion* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanvasElementHitTestRegion();
explicit  CanvasElementHitTestRegion(v8::Isolate* isolate);

bool hasElement() const {
  return has_element_;
}
Element* element() const {
  DCHECK(hasElement());
return member_element_.Get();
}
Element* getElementOr(Element* fallback_value) const {
  if (!hasElement()) {
  return fallback_value;
}
return member_element_.Get();
}
void setElement(Element* value) {
  member_element_ = value;
has_element_ = true;
DCHECK(member_element_);
}

bool hasRect() const {
  return has_rect_;
}
CanvasHitTestRect* rect() const {
  DCHECK(hasRect());
return member_rect_.Get();
}
CanvasHitTestRect* getRectOr(CanvasHitTestRect* fallback_value) const {
  if (!hasRect()) {
  return fallback_value;
}
return member_rect_.Get();
}
void setRect(CanvasHitTestRect* value) {
  member_rect_ = value;
has_rect_ = true;
DCHECK(member_rect_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_element_ = false;
bool has_rect_ = false;

Member<Element> member_element_;
Member<CanvasHitTestRect> member_rect_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CANVAS_ELEMENT_HIT_TEST_REGION_H_
