// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BASE_KEYFRAME_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BASE_KEYFRAME_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_composite_operation_or_auto.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class TimelineRangeOffset;
class V8UnionDoubleOrStringOrTimelineRangeOffset;

class CORE_EXPORT BaseKeyframe : public bindings::DictionaryBase {
  
  public:
static BaseKeyframe* Create() {
  return MakeGarbageCollected<BaseKeyframe>();
}
static BaseKeyframe* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BaseKeyframe>(isolate);
}
static BaseKeyframe* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BaseKeyframe();
explicit  BaseKeyframe(v8::Isolate* isolate);

bool hasComposite() const {
  return true;
}
V8CompositeOperationOrAuto composite() const {
  return member_composite_;
}
void setComposite(V8CompositeOperationOrAuto value) {
  member_composite_ = value;
}
void setComposite(V8CompositeOperationOrAuto::Enum value) {
  member_composite_ = V8CompositeOperationOrAuto(value);
}

bool hasEasing() const {
  return true;
}
const String& easing() const {
  return member_easing_;
}
void setEasing(const String& value);
void setEasing(String&& value);

bool hasOffset() const {
  return true;
}
V8UnionDoubleOrStringOrTimelineRangeOffset* offset() const {
  return member_offset_.Get();
}
void setOffset(V8UnionDoubleOrStringOrTimelineRangeOffset* value) {
  member_offset_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8CompositeOperationOrAuto member_composite_{V8CompositeOperationOrAuto::Enum::kAuto};
String member_easing_{"linear"};
Member<V8UnionDoubleOrStringOrTimelineRangeOffset> member_offset_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BASE_KEYFRAME_H_
