// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var devtools_agent$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/devtools/devtools_agent.mojom', '../devtools/devtools_agent.mojom.js');
  }
  var code_cache$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/code_cache.mojom', '../loader/code_cache.mojom.js');
  }
  var origin_trial_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom', '../origin_trials/origin_trial_feature.mojom.js');
  }
  var browser_interface_broker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/browser_interface_broker.mojom', '../browser_interface_broker.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function WorkletGlobalScopeCreationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkletGlobalScopeCreationParams.prototype.initDefaults_ = function() {
    this.scriptUrl = null;
    this.starterOrigin = null;
    this.originTrialFeatures = null;
    this.devtoolsToken = null;
    this.devtoolsHost = new WorkletDevToolsHostPtr();
    this.codeCacheHost = new code_cache$.CodeCacheHostPtr();
    this.browserInterfaceBroker = new browser_interface_broker$.BrowserInterfaceBrokerPtr();
    this.waitForDebugger = false;
  };
  WorkletGlobalScopeCreationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkletGlobalScopeCreationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.scriptUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.starterOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.originTrialFeatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(origin_trial_feature$.OriginTrialFeature), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.devtoolsToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.devtoolsHost
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.codeCacheHost
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 40, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletGlobalScopeCreationParams.browserInterfaceBroker
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 48, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WorkletGlobalScopeCreationParams.encodedSize = codec.kStructHeaderSize + 64;

  WorkletGlobalScopeCreationParams.decode = function(decoder) {
    var packed;
    var val = new WorkletGlobalScopeCreationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scriptUrl =
        decoder.decodeStructPointer(url$.Url);
    val.starterOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.originTrialFeatures =
        decoder.decodeArrayPointer(new codec.Enum(origin_trial_feature$.OriginTrialFeature));
    val.devtoolsToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.devtoolsHost =
        decoder.decodeStruct(new codec.Interface(WorkletDevToolsHostPtr));
    val.codeCacheHost =
        decoder.decodeStruct(new codec.NullableInterface(code_cache$.CodeCacheHostPtr));
    val.browserInterfaceBroker =
        decoder.decodeStruct(new codec.Interface(browser_interface_broker$.BrowserInterfaceBrokerPtr));
    packed = decoder.readUint8();
    val.waitForDebugger = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WorkletGlobalScopeCreationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkletGlobalScopeCreationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.scriptUrl);
    encoder.encodeStructPointer(origin$.Origin, val.starterOrigin);
    encoder.encodeArrayPointer(new codec.Enum(origin_trial_feature$.OriginTrialFeature), val.originTrialFeatures);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolsToken);
    encoder.encodeStruct(new codec.Interface(WorkletDevToolsHostPtr), val.devtoolsHost);
    encoder.encodeStruct(new codec.NullableInterface(code_cache$.CodeCacheHostPtr), val.codeCacheHost);
    encoder.encodeStruct(new codec.Interface(browser_interface_broker$.BrowserInterfaceBrokerPtr), val.browserInterfaceBroker);
    packed = 0;
    packed |= (val.waitForDebugger & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WorkletDevToolsHost_OnReadyForInspection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WorkletDevToolsHost_OnReadyForInspection_Params.prototype.initDefaults_ = function() {
    this.agent = new devtools_agent$.DevToolsAgentPtr();
    this.agentHost = new bindings.InterfaceRequest();
  };
  WorkletDevToolsHost_OnReadyForInspection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WorkletDevToolsHost_OnReadyForInspection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletDevToolsHost_OnReadyForInspection_Params.agent
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WorkletDevToolsHost_OnReadyForInspection_Params.agentHost
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WorkletDevToolsHost_OnReadyForInspection_Params.encodedSize = codec.kStructHeaderSize + 16;

  WorkletDevToolsHost_OnReadyForInspection_Params.decode = function(decoder) {
    var packed;
    var val = new WorkletDevToolsHost_OnReadyForInspection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.agent =
        decoder.decodeStruct(new codec.Interface(devtools_agent$.DevToolsAgentPtr));
    val.agentHost =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WorkletDevToolsHost_OnReadyForInspection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WorkletDevToolsHost_OnReadyForInspection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(devtools_agent$.DevToolsAgentPtr), val.agent);
    encoder.encodeStruct(codec.InterfaceRequest, val.agentHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kWorkletDevToolsHost_OnReadyForInspection_Name = 0;

  function WorkletDevToolsHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WorkletDevToolsHost,
                                                   handleOrPtrInfo);
  }

  function WorkletDevToolsHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WorkletDevToolsHost, associatedInterfacePtrInfo);
  }

  WorkletDevToolsHostAssociatedPtr.prototype =
      Object.create(WorkletDevToolsHostPtr.prototype);
  WorkletDevToolsHostAssociatedPtr.prototype.constructor =
      WorkletDevToolsHostAssociatedPtr;

  function WorkletDevToolsHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  WorkletDevToolsHostPtr.prototype.onReadyForInspection = function() {
    return WorkletDevToolsHostProxy.prototype.onReadyForInspection
        .apply(this.ptr.getProxy(), arguments);
  };

  WorkletDevToolsHostProxy.prototype.onReadyForInspection = function(agent, agentHost) {
    var params_ = new WorkletDevToolsHost_OnReadyForInspection_Params();
    params_.agent = agent;
    params_.agentHost = agentHost;
    var builder = new codec.MessageV0Builder(
        kWorkletDevToolsHost_OnReadyForInspection_Name,
        codec.align(WorkletDevToolsHost_OnReadyForInspection_Params.encodedSize));
    builder.encodeStruct(WorkletDevToolsHost_OnReadyForInspection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WorkletDevToolsHostStub(delegate) {
    this.delegate_ = delegate;
  }
  WorkletDevToolsHostStub.prototype.onReadyForInspection = function(agent, agentHost) {
    return this.delegate_ && this.delegate_.onReadyForInspection && this.delegate_.onReadyForInspection(agent, agentHost);
  }

  WorkletDevToolsHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWorkletDevToolsHost_OnReadyForInspection_Name:
      var params = reader.decodeStruct(WorkletDevToolsHost_OnReadyForInspection_Params);
      this.onReadyForInspection(params.agent, params.agentHost);
      return true;
    default:
      return false;
    }
  };

  WorkletDevToolsHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWorkletDevToolsHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWorkletDevToolsHost_OnReadyForInspection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WorkletDevToolsHost_OnReadyForInspection_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWorkletDevToolsHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WorkletDevToolsHost = {
    name: 'blink.mojom.WorkletDevToolsHost',
    kVersion: 0,
    ptrClass: WorkletDevToolsHostPtr,
    proxyClass: WorkletDevToolsHostProxy,
    stubClass: WorkletDevToolsHostStub,
    validateRequest: validateWorkletDevToolsHostRequest,
    validateResponse: null,
  };
  WorkletDevToolsHostStub.prototype.validator = validateWorkletDevToolsHostRequest;
  WorkletDevToolsHostProxy.prototype.validator = null;
  exports.WorkletGlobalScopeCreationParams = WorkletGlobalScopeCreationParams;
  exports.WorkletDevToolsHost = WorkletDevToolsHost;
  exports.WorkletDevToolsHostPtr = WorkletDevToolsHostPtr;
  exports.WorkletDevToolsHostAssociatedPtr = WorkletDevToolsHostAssociatedPtr;
})();