// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.OriginTrialFeature');
goog.require('blink.mojom.BrowserInterfaceBroker');
goog.require('blink.mojom.CodeCacheHost');
goog.require('blink.mojom.DevToolsAgent');
goog.require('blink.mojom.DevToolsAgentHost');
goog.require('url.mojom.Origin');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('url.mojom.Url');






goog.provide('blink.mojom.WorkletDevToolsHost');
goog.provide('blink.mojom.WorkletDevToolsHostReceiver');
goog.provide('blink.mojom.WorkletDevToolsHostCallbackRouter');
goog.provide('blink.mojom.WorkletDevToolsHostInterface');
goog.provide('blink.mojom.WorkletDevToolsHostRemote');
goog.provide('blink.mojom.WorkletDevToolsHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WorkletDevToolsHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WorkletDevToolsHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WorkletDevToolsHostInterface = class {
  
  /**
   * @param { !blink.mojom.DevToolsAgentRemote } agent
   * @param { !blink.mojom.DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(agent, agentHost) {}
};

/**
 * @export
 * @implements { blink.mojom.WorkletDevToolsHostInterface }
 */
blink.mojom.WorkletDevToolsHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WorkletDevToolsHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WorkletDevToolsHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WorkletDevToolsHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DevToolsAgentRemote } agent
   * @param { !blink.mojom.DevToolsAgentHostPendingReceiver } agentHost
   */

  onReadyForInspection(
      agent,
      agentHost) {
    this.proxy.sendMessage(
        0,
        blink.mojom.WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
        null,
        [
          agent,
          agentHost
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WorkletDevToolsHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WorkletDevToolsHostReceiver = class {
  /**
   * @param {!blink.mojom.WorkletDevToolsHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WorkletDevToolsHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WorkletDevToolsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WorkletDevToolsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
        null,
        impl.onReadyForInspection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WorkletDevToolsHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WorkletDevToolsHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WorkletDevToolsHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WorkletDevToolsHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WorkletDevToolsHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WorkletDevToolsHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WorkletDevToolsHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WorkletDevToolsHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadyForInspection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
        null,
        this.onReadyForInspection.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.WorkletGlobalScopeCreationParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WorkletGlobalScopeCreationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WorkletDevToolsHost_OnReadyForInspection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WorkletDevToolsHost_OnReadyForInspection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.WorkletGlobalScopeCreationParamsSpec.$,
    'WorkletGlobalScopeCreationParams',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'starterOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originTrialFeatures', 16,
        0,
        mojo.internal.Array(blink.mojom.OriginTrialFeatureSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsToken', 24,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsHost', 32,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.WorkletDevToolsHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'codeCacheHost', 40,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.CodeCacheHostRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'browserInterfaceBroker', 48,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BrowserInterfaceBrokerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'waitForDebugger', 56,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);



goog.provide('blink.mojom.WorkletGlobalScopeCreationParams');

/** @record */
blink.mojom.WorkletGlobalScopeCreationParams = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.scriptUrl;
    /** @export { !url.mojom.Origin } */
    this.starterOrigin;
    /** @export { !Array<!blink.mojom.OriginTrialFeature> } */
    this.originTrialFeatures;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.devtoolsToken;
    /** @export { !blink.mojom.WorkletDevToolsHostRemote } */
    this.devtoolsHost;
    /** @export { (blink.mojom.CodeCacheHostRemote|undefined) } */
    this.codeCacheHost;
    /** @export { !blink.mojom.BrowserInterfaceBrokerRemote } */
    this.browserInterfaceBroker;
    /** @export { !boolean } */
    this.waitForDebugger;
  }
};



mojo.internal.Struct(
    blink.mojom.WorkletDevToolsHost_OnReadyForInspection_ParamsSpec.$,
    'WorkletDevToolsHost_OnReadyForInspection_Params',
    [
      mojo.internal.StructField(
        'agent', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DevToolsAgentRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'agentHost', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.DevToolsAgentHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.WorkletDevToolsHost_OnReadyForInspection_Params');

/** @record */
blink.mojom.WorkletDevToolsHost_OnReadyForInspection_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevToolsAgentRemote } */
    this.agent;
    /** @export { !blink.mojom.DevToolsAgentHostPendingReceiver } */
    this.agentHost;
  }
};

