// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class WorkletGlobalScopeCreationParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WorkletGlobalScopeCreationParamsDataView> {
  using Data = ::blink::mojom::internal::WorkletGlobalScopeCreationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class WorkletDevToolsHostInterfaceBase {};

using WorkletDevToolsHostPtrDataView =
    mojo::InterfacePtrDataView<WorkletDevToolsHostInterfaceBase>;
using WorkletDevToolsHostRequestDataView =
    mojo::InterfaceRequestDataView<WorkletDevToolsHostInterfaceBase>;
using WorkletDevToolsHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WorkletDevToolsHostInterfaceBase>;
using WorkletDevToolsHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WorkletDevToolsHostInterfaceBase>;


class WorkletGlobalScopeCreationParamsDataView {
 public:
  WorkletGlobalScopeCreationParamsDataView() = default;

  WorkletGlobalScopeCreationParamsDataView(
      internal::WorkletGlobalScopeCreationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScriptUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptUrl(UserType* output) {
    
    auto* pointer = data_->script_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetStarterOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStarterOrigin(UserType* output) {
    
    auto* pointer = data_->starter_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetOriginTrialFeaturesDataView(
      mojo::ArrayDataView<::blink::mojom::OriginTrialFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginTrialFeatures(UserType* output) {
    
    auto* pointer = data_->origin_trial_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::OriginTrialFeature>>(
        pointer, output, message_);
  }
  inline void GetDevtoolsTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsToken(UserType* output) {
    
    auto* pointer = data_->devtools_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeDevtoolsHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::WorkletDevToolsHostInterfaceBase>>(
            &data_->devtools_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCodeCacheHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
            &data_->code_cache_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeBrowserInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->browser_interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool wait_for_debugger() const {
    return data_->wait_for_debugger;
  }
 private:
  internal::WorkletGlobalScopeCreationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_DATA_VIEW_H_