// third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::SharedWorkerSameSiteCookies>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedWorkerSameSiteCookies> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedWorkerSameSiteCookies, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedWorkerSameSiteCookies, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedWorkerSameSiteCookies>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedWorkerInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedWorkerInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedWorkerInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SharedWorkerInfo struct");

    decltype(Traits::options(input)) in_options = Traits::options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->options)::BaseType> options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WorkerOptionsDataView>(
      in_options,
      options_fragment);

    fragment->options.Set(
        options_fragment.is_null() ? nullptr : options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SharedWorkerInfo struct");

    decltype(Traits::content_security_policies(input)) in_content_security_policies = Traits::content_security_policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_security_policies)::BaseType>
        content_security_policies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
      in_content_security_policies,
      content_security_policies_fragment,
      &content_security_policies_validate_params);

    fragment->content_security_policies.Set(
        content_security_policies_fragment.is_null() ? nullptr : content_security_policies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_security_policies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_security_policies in SharedWorkerInfo struct");

    decltype(Traits::outside_fetch_client_settings_object(input)) in_outside_fetch_client_settings_object = Traits::outside_fetch_client_settings_object(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
      in_outside_fetch_client_settings_object,
      outside_fetch_client_settings_object_fragment);

    fragment->outside_fetch_client_settings_object.Set(
        outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->outside_fetch_client_settings_object.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outside_fetch_client_settings_object in SharedWorkerInfo struct");

    
    mojo::internal::Serialize<::blink::mojom::SharedWorkerSameSiteCookies>(
      Traits::same_site_cookies(input),
      &fragment->same_site_cookies);

    fragment->extended_lifetime = Traits::extended_lifetime(input);
  }

  static bool Deserialize(::blink::mojom::internal::SharedWorkerInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedWorkerInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SharedWorkerInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SharedWorkerInfoDataView::GetOptionsDataView(
    ::blink::mojom::WorkerOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = ::blink::mojom::WorkerOptionsDataView(pointer, message_);
}
inline void SharedWorkerInfoDataView::GetContentSecurityPoliciesDataView(
    mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output) {
  auto pointer = data_->content_security_policies.Get();
  *output = mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>(pointer, message_);
}
inline void SharedWorkerInfoDataView::GetOutsideFetchClientSettingsObjectDataView(
    ::blink::mojom::FetchClientSettingsObjectDataView* output) {
  auto pointer = data_->outside_fetch_client_settings_object.Get();
  *output = ::blink::mojom::FetchClientSettingsObjectDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedWorkerSameSiteCookies> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedWorkerSameSiteCookies value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SHARED_H_