// third_party/blink/public/mojom/worker/shared_worker_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class SharedWorkerInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SharedWorkerInfoDataView> {
  using Data = ::blink::mojom::internal::SharedWorkerInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SharedWorkerSameSiteCookies : int32_t {
  
  kAll = 0,
  
  kNone = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedWorkerSameSiteCookies value);
inline bool IsKnownEnumValue(SharedWorkerSameSiteCookies value) {
  return internal::SharedWorkerSameSiteCookies_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SharedWorkerInfoDataView {
 public:
  SharedWorkerInfoDataView() = default;

  SharedWorkerInfoDataView(
      internal::SharedWorkerInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      ::blink::mojom::WorkerOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::WorkerOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetContentSecurityPoliciesDataView(
      mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSecurityPolicies(UserType* output) {
    
    auto* pointer = data_->content_security_policies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        pointer, output, message_);
  }
  inline void GetOutsideFetchClientSettingsObjectDataView(
      ::blink::mojom::FetchClientSettingsObjectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutsideFetchClientSettingsObject(UserType* output) {
    
    auto* pointer = data_->outside_fetch_client_settings_object.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchClientSettingsObjectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSameSiteCookies(UserType* output) const {
    auto data_value = data_->same_site_cookies;
    return mojo::internal::Deserialize<::blink::mojom::SharedWorkerSameSiteCookies>(
        data_value, output);
  }
  SharedWorkerSameSiteCookies same_site_cookies() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SharedWorkerSameSiteCookies>(data_->same_site_cookies));
  }
  bool extended_lifetime() const {
    return data_->extended_lifetime;
  }
 private:
  internal::SharedWorkerInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_DATA_VIEW_H_