// third_party/blink/public/mojom/worker/shared_worker_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/content_security_policy.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-blink.h"
#include "third_party/blink/public/mojom/worker/worker_options.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT SharedWorkerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedWorkerInfo, T>::value>;
  using DataView = SharedWorkerInfoDataView;
  using Data_ = internal::SharedWorkerInfo_Data;

  template <typename... Args>
  static SharedWorkerInfoPtr New(Args&&... args) {
    return SharedWorkerInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedWorkerInfoPtr From(const U& u) {
    return mojo::TypeConverter<SharedWorkerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedWorkerInfo>::Convert(*this);
  }


  SharedWorkerInfo();

  SharedWorkerInfo(
      const ::blink::KURL& url,
      ::blink::mojom::blink::WorkerOptionsPtr options,
      ::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policies,
      ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object,
      SharedWorkerSameSiteCookies same_site_cookies,
      bool extended_lifetime);

SharedWorkerInfo(const SharedWorkerInfo&) = delete;
SharedWorkerInfo& operator=(const SharedWorkerInfo&) = delete;

  ~SharedWorkerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedWorkerInfoPtr>
  SharedWorkerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedWorkerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedWorkerInfo_UnserializedMessageContext<
            UserType, SharedWorkerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedWorkerInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedWorkerInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedWorkerInfo_UnserializedMessageContext<
            UserType, SharedWorkerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedWorkerInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::mojom::blink::WorkerOptionsPtr options;
  
  ::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policies;
  
  ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object;
  
  SharedWorkerSameSiteCookies same_site_cookies;
  
  bool extended_lifetime;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedWorkerInfoPtr SharedWorkerInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(options),
      mojo::Clone(content_security_policies),
      mojo::Clone(outside_fetch_client_settings_object),
      mojo::Clone(same_site_cookies),
      mojo::Clone(extended_lifetime)
  );
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>*>
bool SharedWorkerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  if (!mojo::Equals(this->content_security_policies, other_struct.content_security_policies))
    return false;
  if (!mojo::Equals(this->outside_fetch_client_settings_object, other_struct.outside_fetch_client_settings_object))
    return false;
  if (!mojo::Equals(this->same_site_cookies, other_struct.same_site_cookies))
    return false;
  if (!mojo::Equals(this->extended_lifetime, other_struct.extended_lifetime))
    return false;
  return true;
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.options < rhs.options)
    return true;
  if (rhs.options < lhs.options)
    return false;
  if (lhs.content_security_policies < rhs.content_security_policies)
    return true;
  if (rhs.content_security_policies < lhs.content_security_policies)
    return false;
  if (lhs.outside_fetch_client_settings_object < rhs.outside_fetch_client_settings_object)
    return true;
  if (rhs.outside_fetch_client_settings_object < lhs.outside_fetch_client_settings_object)
    return false;
  if (lhs.same_site_cookies < rhs.same_site_cookies)
    return true;
  if (rhs.same_site_cookies < lhs.same_site_cookies)
    return false;
  if (lhs.extended_lifetime < rhs.extended_lifetime)
    return true;
  if (rhs.extended_lifetime < lhs.extended_lifetime)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SharedWorkerInfo::DataView,
                                         ::blink::mojom::blink::SharedWorkerInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::SharedWorkerInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SharedWorkerInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::url)& url(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::options)& options(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->options;
  }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::content_security_policies)& content_security_policies(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->content_security_policies;
  }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::outside_fetch_client_settings_object)& outside_fetch_client_settings_object(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->outside_fetch_client_settings_object;
  }

  static decltype(::blink::mojom::blink::SharedWorkerInfo::same_site_cookies) same_site_cookies(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->same_site_cookies;
  }

  static decltype(::blink::mojom::blink::SharedWorkerInfo::extended_lifetime) extended_lifetime(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->extended_lifetime;
  }

  static bool Read(::blink::mojom::blink::SharedWorkerInfo::DataView input, ::blink::mojom::blink::SharedWorkerInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_BLINK_H_