// third_party/blink/public/mojom/worker/shared_worker_factory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/worker/shared_worker_factory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var user_agent_metadata$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom', '../user_agent/user_agent_metadata.mojom.js');
  }
  var browser_interface_broker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/browser_interface_broker.mojom', '../browser_interface_broker.mojom.js');
  }
  var url_loader_factory_bundle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom', '../loader/url_loader_factory_bundle.mojom.js');
  }
  var renderer_preference_watcher$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/renderer_preference_watcher.mojom', '../renderer_preference_watcher.mojom.js');
  }
  var policy_container$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/policy_container.mojom', '../frame/policy_container.mojom.js');
  }
  var reporting_observer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/reporting_observer.mojom', '../frame/reporting_observer.mojom.js');
  }
  var noise_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom', '../fingerprinting_protection/noise_token.mojom.js');
  }
  var renderer_preferences$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/renderer_preferences.mojom', '../renderer_preferences.mojom.js');
  }
  var controller_service_worker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/controller_service_worker.mojom', '../service_worker/controller_service_worker.mojom.js');
  }
  var service_worker_container$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_container.mojom', '../service_worker/service_worker_container.mojom.js');
  }
  var storage_key$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/storage_key/storage_key.mojom', '../storage_key/storage_key.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var shared_worker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/shared_worker.mojom', 'shared_worker.mojom.js');
  }
  var shared_worker_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/shared_worker_host.mojom', 'shared_worker_host.mojom.js');
  }
  var shared_worker_info$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/shared_worker_info.mojom', 'shared_worker_info.mojom.js');
  }
  var worker_content_settings_proxy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom', 'worker_content_settings_proxy.mojom.js');
  }
  var worker_main_script_load_params$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom', 'worker_main_script_load_params.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }


  var NAVIGATION_SHARED_WORKER_SPEC = "navigation:shared_worker";

  function SharedWorkerFactory_CreateSharedWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedWorkerFactory_CreateSharedWorker_Params.prototype.initDefaults_ = function() {
    this.info = null;
    this.token = null;
    this.constructorKey = null;
    this.origin = null;
    this.isConstructorSecureContext = false;
    this.pauseOnStart = false;
    this.requireCrossSiteRequestForCookies = false;
    this.preferenceWatcherReceiver = new bindings.InterfaceRequest();
    this.userAgent = null;
    this.uaMetadata = null;
    this.devtoolsWorkerToken = null;
    this.rendererPreferences = null;
    this.contentSettings = new worker_content_settings_proxy$.WorkerContentSettingsProxyPtr();
    this.serviceWorkerContainerInfo = null;
    this.mainScriptLoadParams = null;
    this.subresourceLoaderFactories = null;
    this.controllerInfo = null;
    this.policyContainer = null;
    this.host = new shared_worker_host$.SharedWorkerHostPtr();
    this.sharedWorker = new bindings.InterfaceRequest();
    this.browserInterfaceBroker = new browser_interface_broker$.BrowserInterfaceBrokerPtr();
    this.coepReportingObserverReceiver = new bindings.InterfaceRequest();
    this.ukmSourceId = 0;
    this.dipReportingObserverReceiver = new bindings.InterfaceRequest();
  };
  SharedWorkerFactory_CreateSharedWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedWorkerFactory_CreateSharedWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 168}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_worker_info$.SharedWorkerInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tokens$.SharedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.constructorKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, storage_key$.StorageKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedWorkerFactory_CreateSharedWorker_Params.userAgent
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.uaMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, user_agent_metadata$.UserAgentMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedWorkerFactory_CreateSharedWorker_Params.devtoolsWorkerToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.rendererPreferences
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, renderer_preferences$.RendererPreferences, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.preferenceWatcherReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 36, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.contentSettings
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 72, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.serviceWorkerContainerInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, service_worker_container$.ServiceWorkerContainerInfoForClient, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.mainScriptLoadParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, worker_main_script_load_params$.WorkerMainScriptLoadParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.subresourceLoaderFactories
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, url_loader_factory_bundle$.URLLoaderFactoryBundle, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.controllerInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, controller_service_worker$.ControllerServiceWorkerInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.policyContainer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, policy_container$.PolicyContainer, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.host
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 120, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.sharedWorker
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 128, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.browserInterfaceBroker
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 132, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate SharedWorkerFactory_CreateSharedWorker_Params.coepReportingObserverReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 140, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerFactory_CreateSharedWorker_Params.dipReportingObserverReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 152, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedWorkerFactory_CreateSharedWorker_Params.encodedSize = codec.kStructHeaderSize + 160;

  SharedWorkerFactory_CreateSharedWorker_Params.decode = function(decoder) {
    var packed;
    var val = new SharedWorkerFactory_CreateSharedWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(shared_worker_info$.SharedWorkerInfo);
    val.token =
        decoder.decodeStructPointer(tokens$.SharedWorkerToken);
    val.constructorKey =
        decoder.decodeStructPointer(storage_key$.StorageKey);
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    packed = decoder.readUint8();
    val.isConstructorSecureContext = (packed >> 0) & 1 ? true : false;
    val.pauseOnStart = (packed >> 1) & 1 ? true : false;
    val.requireCrossSiteRequestForCookies = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.preferenceWatcherReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.userAgent =
        decoder.decodeStruct(codec.String);
    val.uaMetadata =
        decoder.decodeStructPointer(user_agent_metadata$.UserAgentMetadata);
    val.devtoolsWorkerToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.rendererPreferences =
        decoder.decodeStructPointer(renderer_preferences$.RendererPreferences);
    val.contentSettings =
        decoder.decodeStruct(new codec.Interface(worker_content_settings_proxy$.WorkerContentSettingsProxyPtr));
    val.serviceWorkerContainerInfo =
        decoder.decodeStructPointer(service_worker_container$.ServiceWorkerContainerInfoForClient);
    val.mainScriptLoadParams =
        decoder.decodeStructPointer(worker_main_script_load_params$.WorkerMainScriptLoadParams);
    val.subresourceLoaderFactories =
        decoder.decodeStructPointer(url_loader_factory_bundle$.URLLoaderFactoryBundle);
    val.controllerInfo =
        decoder.decodeStructPointer(controller_service_worker$.ControllerServiceWorkerInfo);
    val.policyContainer =
        decoder.decodeStructPointer(policy_container$.PolicyContainer);
    val.host =
        decoder.decodeStruct(new codec.Interface(shared_worker_host$.SharedWorkerHostPtr));
    val.sharedWorker =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.browserInterfaceBroker =
        decoder.decodeStruct(new codec.Interface(browser_interface_broker$.BrowserInterfaceBrokerPtr));
    val.coepReportingObserverReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.ukmSourceId =
        decoder.decodeStruct(codec.Int64);
    val.dipReportingObserverReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedWorkerFactory_CreateSharedWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedWorkerFactory_CreateSharedWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_worker_info$.SharedWorkerInfo, val.info);
    encoder.encodeStructPointer(tokens$.SharedWorkerToken, val.token);
    encoder.encodeStructPointer(storage_key$.StorageKey, val.constructorKey);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    packed = 0;
    packed |= (val.isConstructorSecureContext & 1) << 0
    packed |= (val.pauseOnStart & 1) << 1
    packed |= (val.requireCrossSiteRequestForCookies & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.InterfaceRequest, val.preferenceWatcherReceiver);
    encoder.encodeStruct(codec.String, val.userAgent);
    encoder.encodeStructPointer(user_agent_metadata$.UserAgentMetadata, val.uaMetadata);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolsWorkerToken);
    encoder.encodeStructPointer(renderer_preferences$.RendererPreferences, val.rendererPreferences);
    encoder.encodeStruct(new codec.Interface(worker_content_settings_proxy$.WorkerContentSettingsProxyPtr), val.contentSettings);
    encoder.encodeStructPointer(service_worker_container$.ServiceWorkerContainerInfoForClient, val.serviceWorkerContainerInfo);
    encoder.encodeStructPointer(worker_main_script_load_params$.WorkerMainScriptLoadParams, val.mainScriptLoadParams);
    encoder.encodeStructPointer(url_loader_factory_bundle$.URLLoaderFactoryBundle, val.subresourceLoaderFactories);
    encoder.encodeStructPointer(controller_service_worker$.ControllerServiceWorkerInfo, val.controllerInfo);
    encoder.encodeStructPointer(policy_container$.PolicyContainer, val.policyContainer);
    encoder.encodeStruct(new codec.Interface(shared_worker_host$.SharedWorkerHostPtr), val.host);
    encoder.encodeStruct(codec.InterfaceRequest, val.sharedWorker);
    encoder.encodeStruct(new codec.Interface(browser_interface_broker$.BrowserInterfaceBrokerPtr), val.browserInterfaceBroker);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.coepReportingObserverReceiver);
    encoder.encodeStruct(codec.Int64, val.ukmSourceId);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.dipReportingObserverReceiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kSharedWorkerFactory_CreateSharedWorker_Name = 0;

  function SharedWorkerFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SharedWorkerFactory,
                                                   handleOrPtrInfo);
  }

  function SharedWorkerFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SharedWorkerFactory, associatedInterfacePtrInfo);
  }

  SharedWorkerFactoryAssociatedPtr.prototype =
      Object.create(SharedWorkerFactoryPtr.prototype);
  SharedWorkerFactoryAssociatedPtr.prototype.constructor =
      SharedWorkerFactoryAssociatedPtr;

  function SharedWorkerFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  SharedWorkerFactoryPtr.prototype.createSharedWorker = function() {
    return SharedWorkerFactoryProxy.prototype.createSharedWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  SharedWorkerFactoryProxy.prototype.createSharedWorker = function(info, token, constructorKey, origin, isConstructorSecureContext, userAgent, uaMetadata, pauseOnStart, devtoolsWorkerToken, rendererPreferences, preferenceWatcherReceiver, contentSettings, serviceWorkerContainerInfo, mainScriptLoadParams, subresourceLoaderFactories, controllerInfo, policyContainer, host, sharedWorker, browserInterfaceBroker, ukmSourceId, requireCrossSiteRequestForCookies, coepReportingObserverReceiver, dipReportingObserverReceiver) {
    var params_ = new SharedWorkerFactory_CreateSharedWorker_Params();
    params_.info = info;
    params_.token = token;
    params_.constructorKey = constructorKey;
    params_.origin = origin;
    params_.isConstructorSecureContext = isConstructorSecureContext;
    params_.userAgent = userAgent;
    params_.uaMetadata = uaMetadata;
    params_.pauseOnStart = pauseOnStart;
    params_.devtoolsWorkerToken = devtoolsWorkerToken;
    params_.rendererPreferences = rendererPreferences;
    params_.preferenceWatcherReceiver = preferenceWatcherReceiver;
    params_.contentSettings = contentSettings;
    params_.serviceWorkerContainerInfo = serviceWorkerContainerInfo;
    params_.mainScriptLoadParams = mainScriptLoadParams;
    params_.subresourceLoaderFactories = subresourceLoaderFactories;
    params_.controllerInfo = controllerInfo;
    params_.policyContainer = policyContainer;
    params_.host = host;
    params_.sharedWorker = sharedWorker;
    params_.browserInterfaceBroker = browserInterfaceBroker;
    params_.ukmSourceId = ukmSourceId;
    params_.requireCrossSiteRequestForCookies = requireCrossSiteRequestForCookies;
    params_.coepReportingObserverReceiver = coepReportingObserverReceiver;
    params_.dipReportingObserverReceiver = dipReportingObserverReceiver;
    var builder = new codec.MessageV2Builder(
        kSharedWorkerFactory_CreateSharedWorker_Name,
        codec.align(SharedWorkerFactory_CreateSharedWorker_Params.encodedSize));
    builder.setPayload(SharedWorkerFactory_CreateSharedWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SharedWorkerFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  SharedWorkerFactoryStub.prototype.createSharedWorker = function(info, token, constructorKey, origin, isConstructorSecureContext, userAgent, uaMetadata, pauseOnStart, devtoolsWorkerToken, rendererPreferences, preferenceWatcherReceiver, contentSettings, serviceWorkerContainerInfo, mainScriptLoadParams, subresourceLoaderFactories, controllerInfo, policyContainer, host, sharedWorker, browserInterfaceBroker, ukmSourceId, requireCrossSiteRequestForCookies, coepReportingObserverReceiver, dipReportingObserverReceiver) {
    return this.delegate_ && this.delegate_.createSharedWorker && this.delegate_.createSharedWorker(info, token, constructorKey, origin, isConstructorSecureContext, userAgent, uaMetadata, pauseOnStart, devtoolsWorkerToken, rendererPreferences, preferenceWatcherReceiver, contentSettings, serviceWorkerContainerInfo, mainScriptLoadParams, subresourceLoaderFactories, controllerInfo, policyContainer, host, sharedWorker, browserInterfaceBroker, ukmSourceId, requireCrossSiteRequestForCookies, coepReportingObserverReceiver, dipReportingObserverReceiver);
  }

  SharedWorkerFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSharedWorkerFactory_CreateSharedWorker_Name:
      var params = reader.decodeStruct(SharedWorkerFactory_CreateSharedWorker_Params);
      this.createSharedWorker(params.info, params.token, params.constructorKey, params.origin, params.isConstructorSecureContext, params.userAgent, params.uaMetadata, params.pauseOnStart, params.devtoolsWorkerToken, params.rendererPreferences, params.preferenceWatcherReceiver, params.contentSettings, params.serviceWorkerContainerInfo, params.mainScriptLoadParams, params.subresourceLoaderFactories, params.controllerInfo, params.policyContainer, params.host, params.sharedWorker, params.browserInterfaceBroker, params.ukmSourceId, params.requireCrossSiteRequestForCookies, params.coepReportingObserverReceiver, params.dipReportingObserverReceiver);
      return true;
    default:
      return false;
    }
  };

  SharedWorkerFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSharedWorkerFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSharedWorkerFactory_CreateSharedWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SharedWorkerFactory_CreateSharedWorker_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSharedWorkerFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SharedWorkerFactory = {
    name: 'blink.mojom.SharedWorkerFactory',
    kVersion: 0,
    ptrClass: SharedWorkerFactoryPtr,
    proxyClass: SharedWorkerFactoryProxy,
    stubClass: SharedWorkerFactoryStub,
    validateRequest: validateSharedWorkerFactoryRequest,
    validateResponse: null,
  };
  SharedWorkerFactoryStub.prototype.validator = validateSharedWorkerFactoryRequest;
  SharedWorkerFactoryProxy.prototype.validator = null;
  exports.NAVIGATION_SHARED_WORKER_SPEC = NAVIGATION_SHARED_WORKER_SPEC;
  exports.SharedWorkerFactory = SharedWorkerFactory;
  exports.SharedWorkerFactoryPtr = SharedWorkerFactoryPtr;
  exports.SharedWorkerFactoryAssociatedPtr = SharedWorkerFactoryAssociatedPtr;
})();