// third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"




#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::SharedWorkerErrorType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedWorkerErrorType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedWorkerErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedWorkerErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedWorkerErrorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedWorkerExceptionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedWorkerExceptionDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedWorkerExceptionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_message)::BaseType> error_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message,
      error_message_fragment);

    fragment->error_message.Set(
        error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error_message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in SharedWorkerExceptionDetails struct");

    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_location)::BaseType> source_location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
      in_source_location,
      source_location_fragment);

    fragment->source_location.Set(
        source_location_fragment.is_null() ? nullptr : source_location_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_location.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_location in SharedWorkerExceptionDetails struct");

    
    mojo::internal::Serialize<::blink::mojom::SharedWorkerErrorType>(
      Traits::error_type(input),
      &fragment->error_type);
  }

  static bool Deserialize(::blink::mojom::internal::SharedWorkerExceptionDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedWorkerExceptionDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SharedWorkerExceptionDetailsDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SharedWorkerExceptionDetailsDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedWorkerErrorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedWorkerErrorType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_SHARED_H_