// third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"


namespace blink::mojom {
class SharedWorkerExceptionDetailsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SharedWorkerExceptionDetailsDataView> {
  using Data = ::blink::mojom::internal::SharedWorkerExceptionDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SharedWorkerErrorType : int32_t {
  
  kParseError = 0,
  
  kRuntimeError = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedWorkerErrorType value);
inline bool IsKnownEnumValue(SharedWorkerErrorType value) {
  return internal::SharedWorkerErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SharedWorkerExceptionDetailsDataView {
 public:
  SharedWorkerExceptionDetailsDataView() = default;

  SharedWorkerExceptionDetailsDataView(
      internal::SharedWorkerExceptionDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorType(UserType* output) const {
    auto data_value = data_->error_type;
    return mojo::internal::Deserialize<::blink::mojom::SharedWorkerErrorType>(
        data_value, output);
  }
  SharedWorkerErrorType error_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SharedWorkerErrorType>(data_->error_type));
  }
 private:
  internal::SharedWorkerExceptionDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_DATA_VIEW_H_