// third_party/blink/public/mojom/worker/shared_worker_connector.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BlobURLTokenRemote as blink_mojom_BlobURLTokenRemote,
  BlobURLTokenPendingReceiver as blink_mojom_BlobURLTokenPendingReceiver
} from '../blob/blob_url_store.mojom.m.js';

import {
  MessagePortDescriptor as blink_mojom_MessagePortDescriptor,
  MessagePortDescriptorSpec as blink_mojom_MessagePortDescriptorSpec
} from '../messaging/message_port_descriptor.mojom.m.js';

import {
  SharedWorkerClientRemote as blink_mojom_SharedWorkerClientRemote,
  SharedWorkerClientPendingReceiver as blink_mojom_SharedWorkerClientPendingReceiver
} from './shared_worker_client.mojom.m.js';

import {
  SharedWorkerCreationContextType as blink_mojom_SharedWorkerCreationContextType,
  SharedWorkerCreationContextTypeSpec as blink_mojom_SharedWorkerCreationContextTypeSpec
} from './shared_worker_creation_context_type.mojom.m.js';

import {
  SharedWorkerInfo as blink_mojom_SharedWorkerInfo,
  SharedWorkerInfoSpec as blink_mojom_SharedWorkerInfoSpec
} from './shared_worker_info.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedWorkerConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedWorkerConnector', scope);
  }
}

/** @interface */
export class SharedWorkerConnectorInterface {
  
  /**
   * @param { !blink_mojom_SharedWorkerInfo } info
   * @param { !blink_mojom_SharedWorkerClientRemote } client
   * @param { !blink_mojom_SharedWorkerCreationContextType } creationContextType
   * @param { !blink_mojom_MessagePortDescriptor } messagePort
   * @param { ?blink_mojom_BlobURLTokenRemote } blobUrlToken
   */

  connect(info, client, creationContextType, messagePort, blobUrlToken) {}
}

/**
 * @implements { SharedWorkerConnectorInterface }
 */
export class SharedWorkerConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedWorkerConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedWorkerConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedWorkerConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_SharedWorkerInfo } info
   * @param { !blink_mojom_SharedWorkerClientRemote } client
   * @param { !blink_mojom_SharedWorkerCreationContextType } creationContextType
   * @param { !blink_mojom_MessagePortDescriptor } messagePort
   * @param { ?blink_mojom_BlobURLTokenRemote } blobUrlToken
   */

  connect(
      info,
      client,
      creationContextType,
      messagePort,
      blobUrlToken) {
    this.proxy.sendMessage(
        0,
        SharedWorkerConnector_Connect_ParamsSpec.$,
        null,
        [
          info,
          client,
          creationContextType,
          messagePort,
          blobUrlToken
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedWorkerConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedWorkerConnectorReceiver {
  /**
   * @param {!SharedWorkerConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedWorkerConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedWorkerConnector_Connect_ParamsSpec.$,
        null,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedWorkerConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedWorkerConnectorRemote}
   */
  static getRemote() {
    let remote = new SharedWorkerConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedWorkerConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedWorkerConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedWorkerConnector_Connect_ParamsSpec.$,
        null,
        this.connect.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerConnector_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedWorkerConnector_Connect_ParamsSpec.$,
    'SharedWorkerConnector_Connect_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink_mojom_SharedWorkerInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_SharedWorkerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'creationContextType', 16,
        0,
        blink_mojom_SharedWorkerCreationContextTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'messagePort', 24,
        0,
        blink_mojom_MessagePortDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 32,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobURLTokenRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SharedWorkerConnector_Connect_Params {
  constructor() {
    /** @type { !blink_mojom_SharedWorkerInfo } */
    this.info;
    /** @type { !blink_mojom_SharedWorkerClientRemote } */
    this.client;
    /** @type { !blink_mojom_SharedWorkerCreationContextType } */
    this.creationContextType;
    /** @type { !blink_mojom_MessagePortDescriptor } */
    this.messagePort;
    /** @type { (blink_mojom_BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
  }
}

