// third_party/blink/public/mojom/worker/shared_worker_connector.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedWorkerConnectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedWorkerConnector.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedWorkerConnectorInterface }
 */
blink.mojom.SharedWorkerConnectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedWorkerConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedWorkerConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedWorkerConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.SharedWorkerInfo } info
   * @param { !blink.mojom.SharedWorkerClientRemote } client
   * @param { !blink.mojom.SharedWorkerCreationContextType } creationContextType
   * @param { !blink.mojom.MessagePortDescriptor } messagePort
   * @param { ?blink.mojom.BlobURLTokenRemote } blobUrlToken
   */

  connect(
      info,
      client,
      creationContextType,
      messagePort,
      blobUrlToken) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedWorkerConnector_Connect_ParamsSpec.$,
        null,
        [
          info,
          client,
          creationContextType,
          messagePort,
          blobUrlToken
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedWorkerConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedWorkerConnectorReceiver = class {
  /**
   * @param {!blink.mojom.SharedWorkerConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedWorkerConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerConnector_Connect_ParamsSpec.$,
        null,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedWorkerConnector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedWorkerConnectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedWorkerConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedWorkerConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedWorkerConnectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerConnector_Connect_ParamsSpec.$,
        null,
        this.connect.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerConnector_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedWorkerConnector_Connect_ParamsSpec.$,
    'SharedWorkerConnector_Connect_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink.mojom.SharedWorkerInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SharedWorkerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'creationContextType', 16,
        0,
        blink.mojom.SharedWorkerCreationContextTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'messagePort', 24,
        0,
        blink.mojom.MessagePortDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 32,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobURLTokenRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.SharedWorkerConnector_Connect_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedWorkerInfo } */
    this.info;
    /** @export { !blink.mojom.SharedWorkerClientRemote } */
    this.client;
    /** @export { !blink.mojom.SharedWorkerCreationContextType } */
    this.creationContextType;
    /** @export { !blink.mojom.MessagePortDescriptor } */
    this.messagePort;
    /** @export { (blink.mojom.BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
  }
};

