// third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/public/common/service_worker/service_worker_embedded_worker_status_mojom_traits.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

DedicatedWorkerHostFactoryClient::IPCStableHashFunction DedicatedWorkerHostFactoryClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DedicatedWorkerHostFactoryClient>(message.name())) {
    case messages::DedicatedWorkerHostFactoryClient::kOnWorkerHostCreated: {
      return &DedicatedWorkerHostFactoryClient::OnWorkerHostCreated_Sym::IPCStableHash;
    }
    case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStarted: {
      return &DedicatedWorkerHostFactoryClient::OnScriptLoadStarted_Sym::IPCStableHash;
    }
    case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStartFailed: {
      return &DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DedicatedWorkerHostFactoryClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DedicatedWorkerHostFactoryClient>(message.name())) {
      case messages::DedicatedWorkerHostFactoryClient::kOnWorkerHostCreated:
            return "Receive blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated";
      case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStarted:
            return "Receive blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted";
      case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStartFailed:
            return "Receive blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed";
    }
  } else {
    switch (static_cast<messages::DedicatedWorkerHostFactoryClient>(message.name())) {
      case messages::DedicatedWorkerHostFactoryClient::kOnWorkerHostCreated:
            return "Receive reply blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated";
      case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStarted:
            return "Receive reply blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted";
      case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStartFailed:
            return "Receive reply blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DedicatedWorkerHostFactoryClient::OnWorkerHostCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48bd21a3;  // IPCStableHash for blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DedicatedWorkerHostFactoryClient::OnScriptLoadStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd54b723f;  // IPCStableHash for blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80c3be66;  // IPCStableHash for blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DedicatedWorkerHostFactoryClientProxy::DedicatedWorkerHostFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DedicatedWorkerHostFactoryClientProxy::OnWorkerHostCreated(
    ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker> in_browser_interface_broker, ::mojo::PendingRemote<::blink::mojom::blink::DedicatedWorkerHost> in_host, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DedicatedWorkerHostFactoryClient::OnWorkerHostCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_interface_broker"), in_browser_interface_broker,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::DedicatedWorkerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DedicatedWorkerHostFactoryClient::kOnWorkerHostCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
    in_browser_interface_broker,
    &params->browser_interface_broker,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->browser_interface_broker)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid browser_interface_broker in DedicatedWorkerHostFactoryClient.OnWorkerHostCreated request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DedicatedWorkerHostInterfaceBase>>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host in DedicatedWorkerHostFactoryClient.OnWorkerHostCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in DedicatedWorkerHostFactoryClient.OnWorkerHostCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactoryClient::Name_);
  message.set_method_name("OnWorkerHostCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DedicatedWorkerHostFactoryClientProxy::OnScriptLoadStarted(
    ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr in_service_worker_container_info, ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr in_main_script_load_params, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, ::mojo::PendingReceiver<::blink::mojom::blink::SubresourceLoaderUpdater> in_subresource_loader_updater, ::blink::mojom::blink::ControllerServiceWorkerInfoPtr in_controller_info, ::mojo::PendingRemote<::blink::mojom::blink::BackForwardCacheControllerHost> in_back_forward_cache_controller_host, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> in_coep_reporting_observer_receiver, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> in_dip_reporting_observer_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_container_info"), in_service_worker_container_info,
                        "<value of type ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_script_load_params"), in_main_script_load_params,
                        "<value of type ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_updater"), in_subresource_loader_updater,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::SubresourceLoaderUpdater>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_info"), in_controller_info,
                        "<value of type ::blink::mojom::blink::ControllerServiceWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("back_forward_cache_controller_host"), in_back_forward_cache_controller_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::BackForwardCacheControllerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coep_reporting_observer_receiver"), in_coep_reporting_observer_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dip_reporting_observer_receiver"), in_dip_reporting_observer_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_container_info)::BaseType> service_worker_container_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
    in_service_worker_container_info,
    service_worker_container_info_fragment);

  params->service_worker_container_info.Set(
      service_worker_container_info_fragment.is_null() ? nullptr : service_worker_container_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->main_script_load_params)::BaseType> main_script_load_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WorkerMainScriptLoadParamsDataView>(
    in_main_script_load_params,
    main_script_load_params_fragment);

  params->main_script_load_params.Set(
      main_script_load_params_fragment.is_null() ? nullptr : main_script_load_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->main_script_load_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null main_script_load_params in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
    in_subresource_loader_factories,
    subresource_loader_factories_fragment);

  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_loader_factories.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_loader_factories in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SubresourceLoaderUpdaterInterfaceBase>>(
    in_subresource_loader_updater,
    &params->subresource_loader_updater,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->subresource_loader_updater)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid subresource_loader_updater in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");
  mojo::internal::MessageFragment<
      typename decltype(params->controller_info)::BaseType> controller_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
    in_controller_info,
    controller_info_fragment);

  params->controller_info.Set(
      controller_info_fragment.is_null() ? nullptr : controller_info_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BackForwardCacheControllerHostInterfaceBase>>(
    in_back_forward_cache_controller_host,
    &params->back_forward_cache_controller_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->back_forward_cache_controller_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid back_forward_cache_controller_host in DedicatedWorkerHostFactoryClient.OnScriptLoadStarted request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
    in_coep_reporting_observer_receiver,
    &params->coep_reporting_observer_receiver,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
    in_dip_reporting_observer_receiver,
    &params->dip_reporting_observer_receiver,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactoryClient::Name_);
  message.set_method_name("OnScriptLoadStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DedicatedWorkerHostFactoryClientProxy::OnScriptLoadStartFailed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DedicatedWorkerHostFactoryClient::OnScriptLoadStartFailed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStartFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactoryClient::Name_);
  message.set_method_name("OnScriptLoadStartFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DedicatedWorkerHostFactoryClientStubDispatch::Accept(
    DedicatedWorkerHostFactoryClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DedicatedWorkerHostFactoryClient>(message->header()->name)) {
    case messages::DedicatedWorkerHostFactoryClient::kOnWorkerHostCreated: {
      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DedicatedWorkerHostFactoryClient.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker> p_browser_interface_broker{};
      ::mojo::PendingRemote<::blink::mojom::blink::DedicatedWorkerHost> p_host{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_browser_interface_broker =
            input_data_view.TakeBrowserInterfaceBroker<decltype(p_browser_interface_broker)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactoryClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWorkerHostCreated(        
        std::move(p_browser_interface_broker), 
        std::move(p_host), 
        std::move(p_origin));
      return true;
    }
    case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStarted: {
      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DedicatedWorkerHostFactoryClient.1
      bool success = true;
      ::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr p_service_worker_container_info{};
      ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr p_main_script_load_params{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::mojo::PendingReceiver<::blink::mojom::blink::SubresourceLoaderUpdater> p_subresource_loader_updater{};
      ::blink::mojom::blink::ControllerServiceWorkerInfoPtr p_controller_info{};
      ::mojo::PendingRemote<::blink::mojom::blink::BackForwardCacheControllerHost> p_back_forward_cache_controller_host{};
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> p_coep_reporting_observer_receiver{};
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> p_dip_reporting_observer_receiver{};
      DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceWorkerContainerInfo(&p_service_worker_container_info))
        success = false;
      if (success && !input_data_view.ReadMainScriptLoadParams(&p_main_script_load_params))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success) {
        p_subresource_loader_updater =
            input_data_view.TakeSubresourceLoaderUpdater<decltype(p_subresource_loader_updater)>();
      }
      if (success && !input_data_view.ReadControllerInfo(&p_controller_info))
        success = false;
      if (success) {
        p_back_forward_cache_controller_host =
            input_data_view.TakeBackForwardCacheControllerHost<decltype(p_back_forward_cache_controller_host)>();
      }
      if (success) {
        p_coep_reporting_observer_receiver =
            input_data_view.TakeCoepReportingObserverReceiver<decltype(p_coep_reporting_observer_receiver)>();
      }
      if (success) {
        p_dip_reporting_observer_receiver =
            input_data_view.TakeDipReportingObserverReceiver<decltype(p_dip_reporting_observer_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactoryClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadStarted(        
        std::move(p_service_worker_container_info), 
        std::move(p_main_script_load_params), 
        std::move(p_subresource_loader_factories), 
        std::move(p_subresource_loader_updater), 
        std::move(p_controller_info), 
        std::move(p_back_forward_cache_controller_host), 
        std::move(p_coep_reporting_observer_receiver), 
        std::move(p_dip_reporting_observer_receiver));
      return true;
    }
    case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStartFailed: {
      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DedicatedWorkerHostFactoryClient.2
      bool success = true;
      DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactoryClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadStartFailed(        );
      return true;
    }
  }
  return false;
}

// static
bool DedicatedWorkerHostFactoryClientStubDispatch::AcceptWithResponder(
    DedicatedWorkerHostFactoryClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DedicatedWorkerHostFactoryClient>(message->header()->name)) {
    case messages::DedicatedWorkerHostFactoryClient::kOnWorkerHostCreated: {
      break;
    }
    case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStarted: {
      break;
    }
    case messages::DedicatedWorkerHostFactoryClient::kOnScriptLoadStartFailed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDedicatedWorkerHostFactoryClientValidationInfo[] = {
    { &internal::DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params_Data::Validate,
     nullptr /* no response */},
};

bool DedicatedWorkerHostFactoryClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DedicatedWorkerHostFactoryClient::Name_,
    kDedicatedWorkerHostFactoryClientValidationInfo);
}

// The declaration includes the definition on other builds.

DedicatedWorkerHostFactory::IPCStableHashFunction DedicatedWorkerHostFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DedicatedWorkerHostFactory>(message.name())) {
    case messages::DedicatedWorkerHostFactory::kCreateWorkerHostAndStartScriptLoad: {
      return &DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DedicatedWorkerHostFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DedicatedWorkerHostFactory>(message.name())) {
      case messages::DedicatedWorkerHostFactory::kCreateWorkerHostAndStartScriptLoad:
            return "Receive blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad";
    }
  } else {
    switch (static_cast<messages::DedicatedWorkerHostFactory>(message.name())) {
      case messages::DedicatedWorkerHostFactory::kCreateWorkerHostAndStartScriptLoad:
            return "Receive reply blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47ecdc1b;  // IPCStableHash for blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DedicatedWorkerHostFactoryProxy::DedicatedWorkerHostFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DedicatedWorkerHostFactoryProxy::CreateWorkerHostAndStartScriptLoad(
    const ::blink::DedicatedWorkerToken& in_token, const ::blink::KURL& in_script_url, ::network::mojom::blink::CredentialsMode in_credentials_mode, ::blink::mojom::blink::FetchClientSettingsObjectPtr in_outside_fetch_client_settings_object, ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> in_blob_url_token, ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient> in_client, ::net::StorageAccessApiStatus in_storage_access_api_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DedicatedWorkerHostFactory::CreateWorkerHostAndStartScriptLoad", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::DedicatedWorkerToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials_mode"), in_credentials_mode,
                        "<value of type ::network::mojom::blink::CredentialsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("outside_fetch_client_settings_object"), in_outside_fetch_client_settings_object,
                        "<value of type ::blink::mojom::blink::FetchClientSettingsObjectPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob_url_token"), in_blob_url_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DedicatedWorkerHostFactory::kCreateWorkerHostAndStartScriptLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DedicatedWorkerTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_script_url,
    script_url_fragment);

  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_url in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");

  
  mojo::internal::Serialize<::network::mojom::CredentialsMode>(
    in_credentials_mode,
    &params->credentials_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
    in_outside_fetch_client_settings_object,
    outside_fetch_client_settings_object_fragment);

  params->outside_fetch_client_settings_object.Set(
      outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->outside_fetch_client_settings_object.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null outside_fetch_client_settings_object in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
    in_blob_url_token,
    &params->blob_url_token,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DedicatedWorkerHostFactoryClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in DedicatedWorkerHostFactory.CreateWorkerHostAndStartScriptLoad request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DedicatedWorkerHostFactory::Name_);
  message.set_method_name("CreateWorkerHostAndStartScriptLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DedicatedWorkerHostFactoryStubDispatch::Accept(
    DedicatedWorkerHostFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DedicatedWorkerHostFactory>(message->header()->name)) {
    case messages::DedicatedWorkerHostFactory::kCreateWorkerHostAndStartScriptLoad: {
      DCHECK(message->is_serialized());
      internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data* params =
          reinterpret_cast<internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DedicatedWorkerHostFactory.0
      bool success = true;
      ::blink::DedicatedWorkerToken p_token{};
      ::blink::KURL p_script_url{};
      ::network::mojom::blink::CredentialsMode p_credentials_mode{};
      ::blink::mojom::blink::FetchClientSettingsObjectPtr p_outside_fetch_client_settings_object{};
      ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> p_blob_url_token{};
      ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient> p_client{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (success && !input_data_view.ReadCredentialsMode(&p_credentials_mode))
        success = false;
      if (success && !input_data_view.ReadOutsideFetchClientSettingsObject(&p_outside_fetch_client_settings_object))
        success = false;
      if (success) {
        p_blob_url_token =
            input_data_view.TakeBlobUrlToken<decltype(p_blob_url_token)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DedicatedWorkerHostFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWorkerHostAndStartScriptLoad(        
        std::move(p_token), 
        std::move(p_script_url), 
        std::move(p_credentials_mode), 
        std::move(p_outside_fetch_client_settings_object), 
        std::move(p_blob_url_token), 
        std::move(p_client), 
        std::move(p_storage_access_api_status));
      return true;
    }
  }
  return false;
}

// static
bool DedicatedWorkerHostFactoryStubDispatch::AcceptWithResponder(
    DedicatedWorkerHostFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DedicatedWorkerHostFactory>(message->header()->name)) {
    case messages::DedicatedWorkerHostFactory::kCreateWorkerHostAndStartScriptLoad: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDedicatedWorkerHostFactoryValidationInfo[] = {
    { &internal::DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params_Data::Validate,
     nullptr /* no response */},
};

bool DedicatedWorkerHostFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DedicatedWorkerHostFactory::Name_,
    kDedicatedWorkerHostFactoryValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DedicatedWorkerHostFactoryClientInterceptorForTesting::OnWorkerHostCreated(::mojo::PendingRemote<::blink::mojom::blink::BrowserInterfaceBroker> browser_interface_broker, ::mojo::PendingRemote<::blink::mojom::blink::DedicatedWorkerHost> host, const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) {
  GetForwardingInterface()->OnWorkerHostCreated(
    std::move(browser_interface_broker)
    , 
    std::move(host)
    , 
    std::move(origin)
    );
}
void DedicatedWorkerHostFactoryClientInterceptorForTesting::OnScriptLoadStarted(::blink::mojom::blink::ServiceWorkerContainerInfoForClientPtr service_worker_container_info, ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr main_script_load_params, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories, ::mojo::PendingReceiver<::blink::mojom::blink::SubresourceLoaderUpdater> subresource_loader_updater, ::blink::mojom::blink::ControllerServiceWorkerInfoPtr controller_info, ::mojo::PendingRemote<::blink::mojom::blink::BackForwardCacheControllerHost> back_forward_cache_controller_host, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> coep_reporting_observer_receiver, ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> dip_reporting_observer_receiver) {
  GetForwardingInterface()->OnScriptLoadStarted(
    std::move(service_worker_container_info)
    , 
    std::move(main_script_load_params)
    , 
    std::move(subresource_loader_factories)
    , 
    std::move(subresource_loader_updater)
    , 
    std::move(controller_info)
    , 
    std::move(back_forward_cache_controller_host)
    , 
    std::move(coep_reporting_observer_receiver)
    , 
    std::move(dip_reporting_observer_receiver)
    );
}
void DedicatedWorkerHostFactoryClientInterceptorForTesting::OnScriptLoadStartFailed() {
  GetForwardingInterface()->OnScriptLoadStartFailed();
}
DedicatedWorkerHostFactoryClientAsyncWaiter::DedicatedWorkerHostFactoryClientAsyncWaiter(
    DedicatedWorkerHostFactoryClient* proxy) : proxy_(proxy) {}

DedicatedWorkerHostFactoryClientAsyncWaiter::~DedicatedWorkerHostFactoryClientAsyncWaiter() = default;





void DedicatedWorkerHostFactoryInterceptorForTesting::CreateWorkerHostAndStartScriptLoad(const ::blink::DedicatedWorkerToken& token, const ::blink::KURL& script_url, ::network::mojom::blink::CredentialsMode credentials_mode, ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> blob_url_token, ::mojo::PendingRemote<DedicatedWorkerHostFactoryClient> client, ::net::StorageAccessApiStatus storage_access_api_status) {
  GetForwardingInterface()->CreateWorkerHostAndStartScriptLoad(
    std::move(token)
    , 
    std::move(script_url)
    , 
    std::move(credentials_mode)
    , 
    std::move(outside_fetch_client_settings_object)
    , 
    std::move(blob_url_token)
    , 
    std::move(client)
    , 
    std::move(storage_access_api_status)
    );
}
DedicatedWorkerHostFactoryAsyncWaiter::DedicatedWorkerHostFactoryAsyncWaiter(
    DedicatedWorkerHostFactory* proxy) : proxy_(proxy) {}

DedicatedWorkerHostFactoryAsyncWaiter::~DedicatedWorkerHostFactoryAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif