// third_party/blink/public/mojom/window_features/window_features.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WINDOW_FEATURES_WINDOW_FEATURES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WINDOW_FEATURES_WINDOW_FEATURES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/window_features/window_features.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/window_features/window_features.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT WindowFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WindowFeatures, T>::value>;
  using DataView = WindowFeaturesDataView;
  using Data_ = internal::WindowFeatures_Data;

  template <typename... Args>
  static WindowFeaturesPtr New(Args&&... args) {
    return WindowFeaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WindowFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<WindowFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WindowFeatures>::Convert(*this);
  }


  WindowFeatures();

  WindowFeatures(
      const ::gfx::Rect& bounds,
      bool has_x,
      bool has_y,
      bool has_width,
      bool has_height,
      bool is_popup);


  ~WindowFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WindowFeaturesPtr>
  WindowFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowFeatures::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WindowFeatures::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WindowFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WindowFeatures_UnserializedMessageContext<
            UserType, WindowFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WindowFeatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WindowFeatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WindowFeatures_UnserializedMessageContext<
            UserType, WindowFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WindowFeatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect bounds;
  
  bool has_x;
  
  bool has_y;
  
  bool has_width;
  
  bool has_height;
  
  bool is_popup;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WindowFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WindowFeaturesPtr WindowFeatures::Clone() const {
  return New(
      mojo::Clone(bounds),
      mojo::Clone(has_x),
      mojo::Clone(has_y),
      mojo::Clone(has_width),
      mojo::Clone(has_height),
      mojo::Clone(is_popup)
  );
}

template <typename T, WindowFeatures::EnableIfSame<T>*>
bool WindowFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->has_x, other_struct.has_x))
    return false;
  if (!mojo::Equals(this->has_y, other_struct.has_y))
    return false;
  if (!mojo::Equals(this->has_width, other_struct.has_width))
    return false;
  if (!mojo::Equals(this->has_height, other_struct.has_height))
    return false;
  if (!mojo::Equals(this->is_popup, other_struct.is_popup))
    return false;
  return true;
}

template <typename T, WindowFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.has_x < rhs.has_x)
    return true;
  if (rhs.has_x < lhs.has_x)
    return false;
  if (lhs.has_y < rhs.has_y)
    return true;
  if (rhs.has_y < lhs.has_y)
    return false;
  if (lhs.has_width < rhs.has_width)
    return true;
  if (rhs.has_width < lhs.has_width)
    return false;
  if (lhs.has_height < rhs.has_height)
    return true;
  if (rhs.has_height < lhs.has_height)
    return false;
  if (lhs.is_popup < rhs.is_popup)
    return true;
  if (rhs.is_popup < lhs.is_popup)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WindowFeatures::DataView,
                                         ::blink::mojom::blink::WindowFeaturesPtr> {
  static bool IsNull(const ::blink::mojom::blink::WindowFeaturesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WindowFeaturesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WindowFeatures::bounds)& bounds(
      const ::blink::mojom::blink::WindowFeaturesPtr& input) {
    return input->bounds;
  }

  static decltype(::blink::mojom::blink::WindowFeatures::has_x) has_x(
      const ::blink::mojom::blink::WindowFeaturesPtr& input) {
    return input->has_x;
  }

  static decltype(::blink::mojom::blink::WindowFeatures::has_y) has_y(
      const ::blink::mojom::blink::WindowFeaturesPtr& input) {
    return input->has_y;
  }

  static decltype(::blink::mojom::blink::WindowFeatures::has_width) has_width(
      const ::blink::mojom::blink::WindowFeaturesPtr& input) {
    return input->has_width;
  }

  static decltype(::blink::mojom::blink::WindowFeatures::has_height) has_height(
      const ::blink::mojom::blink::WindowFeaturesPtr& input) {
    return input->has_height;
  }

  static decltype(::blink::mojom::blink::WindowFeatures::is_popup) is_popup(
      const ::blink::mojom::blink::WindowFeaturesPtr& input) {
    return input->is_popup;
  }

  static bool Read(::blink::mojom::blink::WindowFeatures::DataView input, ::blink::mojom::blink::WindowFeaturesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WINDOW_FEATURES_WINDOW_FEATURES_MOJOM_BLINK_H_