// third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_params.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/base/mojom/window_show_state.mojom-shared.h"




#include "third_party/blink/public/mojom/widget/visual_properties.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::VisualPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VisualPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::VisualProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::screen_infos(input)) in_screen_infos = Traits::screen_infos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screen_infos)::BaseType> screen_infos_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::display::mojom::ScreenInfosDataView>(
      in_screen_infos,
      screen_infos_fragment);

    fragment->screen_infos.Set(
        screen_infos_fragment.is_null() ? nullptr : screen_infos_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->screen_infos.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screen_infos in VisualProperties struct");

    fragment->auto_resize_enabled = Traits::auto_resize_enabled(input);

    fragment->resizable = Traits::resizable(input);

    decltype(Traits::min_size_for_auto_resize(input)) in_min_size_for_auto_resize = Traits::min_size_for_auto_resize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_size_for_auto_resize)::BaseType> min_size_for_auto_resize_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_size_for_auto_resize,
      min_size_for_auto_resize_fragment);

    fragment->min_size_for_auto_resize.Set(
        min_size_for_auto_resize_fragment.is_null() ? nullptr : min_size_for_auto_resize_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->min_size_for_auto_resize.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_size_for_auto_resize in VisualProperties struct");

    decltype(Traits::max_size_for_auto_resize(input)) in_max_size_for_auto_resize = Traits::max_size_for_auto_resize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_size_for_auto_resize)::BaseType> max_size_for_auto_resize_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_size_for_auto_resize,
      max_size_for_auto_resize_fragment);

    fragment->max_size_for_auto_resize.Set(
        max_size_for_auto_resize_fragment.is_null() ? nullptr : max_size_for_auto_resize_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_size_for_auto_resize.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_size_for_auto_resize in VisualProperties struct");

    decltype(Traits::new_size_device_px(input)) in_new_size_device_px = Traits::new_size_device_px(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_size_device_px)::BaseType> new_size_device_px_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_new_size_device_px,
      new_size_device_px_fragment);

    fragment->new_size_device_px.Set(
        new_size_device_px_fragment.is_null() ? nullptr : new_size_device_px_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->new_size_device_px.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_size_device_px in VisualProperties struct");

    decltype(Traits::visible_viewport_size_device_px(input)) in_visible_viewport_size_device_px = Traits::visible_viewport_size_device_px(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_viewport_size_device_px)::BaseType> visible_viewport_size_device_px_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_visible_viewport_size_device_px,
      visible_viewport_size_device_px_fragment);

    fragment->visible_viewport_size_device_px.Set(
        visible_viewport_size_device_px_fragment.is_null() ? nullptr : visible_viewport_size_device_px_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_viewport_size_device_px.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_viewport_size_device_px in VisualProperties struct");

    decltype(Traits::compositor_viewport_pixel_rect(input)) in_compositor_viewport_pixel_rect = Traits::compositor_viewport_pixel_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->compositor_viewport_pixel_rect)::BaseType> compositor_viewport_pixel_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_compositor_viewport_pixel_rect,
      compositor_viewport_pixel_rect_fragment);

    fragment->compositor_viewport_pixel_rect.Set(
        compositor_viewport_pixel_rect_fragment.is_null() ? nullptr : compositor_viewport_pixel_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->compositor_viewport_pixel_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null compositor_viewport_pixel_rect in VisualProperties struct");

    decltype(Traits::browser_controls_params(input)) in_browser_controls_params = Traits::browser_controls_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browser_controls_params)::BaseType> browser_controls_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::BrowserControlsParamsDataView>(
      in_browser_controls_params,
      browser_controls_params_fragment);

    fragment->browser_controls_params.Set(
        browser_controls_params_fragment.is_null() ? nullptr : browser_controls_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browser_controls_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_controls_params in VisualProperties struct");

    fragment->scroll_focused_node_into_view = Traits::scroll_focused_node_into_view(input);

    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id,
      local_surface_id_fragment);

    fragment->local_surface_id.Set(
        local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

    fragment->is_fullscreen_granted = Traits::is_fullscreen_granted(input);

    
    mojo::internal::Serialize<::blink::mojom::DisplayMode>(
      Traits::display_mode(input),
      &fragment->display_mode);

    
    mojo::internal::Serialize<::ui::mojom::WindowShowState>(
      Traits::window_show_state(input),
      &fragment->window_show_state);

    fragment->capture_sequence_number = Traits::capture_sequence_number(input);

    fragment->zoom_level = Traits::zoom_level(input);

    fragment->css_zoom_factor = Traits::css_zoom_factor(input);

    fragment->page_scale_factor = Traits::page_scale_factor(input);

    fragment->compositing_scale_factor = Traits::compositing_scale_factor(input);

    fragment->cursor_accessibility_scale_factor = Traits::cursor_accessibility_scale_factor(input);

    decltype(Traits::root_widget_viewport_segments(input)) in_root_widget_viewport_segments = Traits::root_widget_viewport_segments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_widget_viewport_segments)::BaseType>
        root_widget_viewport_segments_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& root_widget_viewport_segments_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
      in_root_widget_viewport_segments,
      root_widget_viewport_segments_fragment,
      &root_widget_viewport_segments_validate_params);

    fragment->root_widget_viewport_segments.Set(
        root_widget_viewport_segments_fragment.is_null() ? nullptr : root_widget_viewport_segments_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->root_widget_viewport_segments.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_widget_viewport_segments in VisualProperties struct");

    fragment->is_pinch_gesture_active = Traits::is_pinch_gesture_active(input);

    decltype(Traits::window_controls_overlay_rect(input)) in_window_controls_overlay_rect = Traits::window_controls_overlay_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->window_controls_overlay_rect)::BaseType> window_controls_overlay_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_window_controls_overlay_rect,
      window_controls_overlay_rect_fragment);

    fragment->window_controls_overlay_rect.Set(
        window_controls_overlay_rect_fragment.is_null() ? nullptr : window_controls_overlay_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->window_controls_overlay_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_controls_overlay_rect in VisualProperties struct");

    fragment->virtual_keyboard_resize_height_device_px = Traits::virtual_keyboard_resize_height_device_px(input);
  }

  static bool Deserialize(::blink::mojom::internal::VisualProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::VisualPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void VisualPropertiesDataView::GetScreenInfosDataView(
    ::display::mojom::ScreenInfosDataView* output) {
  auto pointer = data_->screen_infos.Get();
  *output = ::display::mojom::ScreenInfosDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetMinSizeForAutoResizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_size_for_auto_resize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetMaxSizeForAutoResizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_size_for_auto_resize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetNewSizeDevicePxDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->new_size_device_px.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetVisibleViewportSizeDevicePxDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->visible_viewport_size_device_px.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetCompositorViewportPixelRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->compositor_viewport_pixel_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetBrowserControlsParamsDataView(
    ::cc::mojom::BrowserControlsParamsDataView* output) {
  auto pointer = data_->browser_controls_params.Get();
  *output = ::cc::mojom::BrowserControlsParamsDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void VisualPropertiesDataView::GetRootWidgetViewportSegmentsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->root_widget_viewport_segments.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}
inline void VisualPropertiesDataView::GetWindowControlsOverlayRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->window_controls_overlay_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_SHARED_H_